package cn.quantgroup.report.utils;


import lombok.extern.slf4j.Slf4j;

import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

@Slf4j
public class TrustServerManager implements X509TrustManager {
  X509TrustManager sunJSSEX509TrustManager;

  public TrustServerManager(String type, InputStream inputStream, String password) throws Exception {
    KeyStore ks = KeyStore.getInstance(type);
    ks.load(inputStream, password.toCharArray());
    TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
    tmf.init(ks);
    TrustManager tms[] = tmf.getTrustManagers();
    /*
     * Iterate over the returned trustmanagers, look for an instance of
		 * X509TrustManager. If found, use that as our "default" trust manager.
		 */
    for (int i = 0; i < tms.length; i++) {
      if (tms[i] instanceof X509TrustManager) {
        sunJSSEX509TrustManager = (X509TrustManager) tms[i];
        return;
      }
    }
    throw new RuntimeException("TrustServerManager Couldn't initialize");
  }

  public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    try {
      sunJSSEX509TrustManager.checkClientTrusted(chain, authType);
    } catch (CertificateException ex) {
      log.error("checkClientTrusted fail", ex);
    }
  }

  public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    try {
      sunJSSEX509TrustManager.checkServerTrusted(chain, authType);
    } catch (CertificateException ex) {
      log.error("checkServerTrusted fail,authType:{}", authType, ex);
    }
  }

  /*
   * Merely pass this through.
   */
  public X509Certificate[] getAcceptedIssuers() {
    return sunJSSEX509TrustManager.getAcceptedIssuers();
  }

}
