package cn.quantgroup.report.controller.external;

import cn.quantgroup.report.service.repair.RepairService;
import com.google.common.base.Stopwatch;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.concurrent.TimeUnit;

/**
 * @author jian.zheng
 * @date 2021/3/2 - 18:43
 **/
@Slf4j
@RestController("/zhudai")
public class RepairController {


    @Autowired
    RepairService repairService;
    /**
     * 修复数据
     * pageNo 从0开始
     */
    @RequestMapping("/repair")
    public String mainLoanInfoSend(int startPage){
        try{
            Stopwatch stopwatch = Stopwatch.createStarted();
            repairService.doRepair("normal_lh",startPage);
            repairService.doRepair("overdue_lh",startPage);
            repairService.doRepair("normal",startPage);
            repairService.doRepair("overdue",startPage);
            log.info("本次测试总耗时 {}",stopwatch.elapsed(TimeUnit.MILLISECONDS));
            log.info("数据补报成功");
            return "数据补报成功";
        }catch(Exception e){
            log.error("数据补报出现异常", e);
            return "数据补报出现异常";
        }
    }

}
