package com.quantgroup.asset.distribution.service.jpa.repository;

import com.quantgroup.asset.distribution.service.jpa.entity.DistributeFailLog;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;

import java.sql.Timestamp;

/**
 * 分发失败Repository
 *
 * @author liwenbin
 */
public interface IDistributeFailLogRepository extends JpaRepository<DistributeFailLog, Long> {

    /**
     * 根据时间查询失败订单
     *
     * @param start
     * @param end
     * @param enable
     * @param pageable
     * @return
     */
    public Page<DistributeFailLog> findByCreatedAtBetweenAndEnable(Timestamp start, Timestamp end, Boolean enable, Pageable pageable);

    /**
     * 根据assentNo查询失败订单
     *
     * @param assentNo
     * @param enable
     * @return
     */
    DistributeFailLog findByAssetNoAndEnable(String assentNo, boolean enable);
}
