package com.quantgroup.asset.distribution.util;

import com.alibaba.fastjson.JSON;
import com.lkb.data.hbase.row.verify.OCRIdCardRow;
import com.quantgroup.asset.distribution.model.entity.OcrIdCardEntity;
import com.quantgroup.asset.distribution.service.niwodai.vo.IdCardA;
import com.quantgroup.asset.distribution.service.niwodai.vo.IdCardB;

/**
 * @author : Hyuk
 * @description : OcrUtils
 * @date : 2020/6/5 6:40 下午
 */
public class OcrUtils {

    /**
     * OCRIdCardRow转化成OcrIdCardEntity
     * @param ocrIdCardRow
     * @return
     */
    public static OcrIdCardEntity transForm(OCRIdCardRow ocrIdCardRow) {
        if (ocrIdCardRow == null) { return null; }
        OcrIdCardEntity ocrIdCardEntity = new OcrIdCardEntity();
        ocrIdCardEntity.setIdCardA(JSON.parseObject(ocrIdCardRow.getIdCardContentA(), IdCardA.class));
        ocrIdCardEntity.setIdCardB(JSON.parseObject(ocrIdCardRow.getIdCardContentB(), IdCardB.class));
        ocrIdCardEntity.setIdCardBaseContentA(ocrIdCardRow.getIdCardBaseContentA());
        ocrIdCardEntity.setIdCardBaseContentB(ocrIdCardRow.getIdCardBaseContentB());
        ocrIdCardEntity.setLivePhotoContent(ocrIdCardRow.getLivePhotoContent());
        return ocrIdCardEntity;
    }
}
