package com.quantgroup.asset.distribution.controller;

import java.sql.Timestamp;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.quantgroup.asset.distribution.model.form.AssetForm;
import com.quantgroup.asset.distribution.model.response.GlobalResponse;
import com.quantgroup.asset.distribution.service.asset.IAssetService;
import com.quantgroup.asset.distribution.service.jpa.entity.DistributeFailLog;
import com.quantgroup.asset.distribution.service.jpa.repository.IDistributeFailLogRepository;

import lombok.extern.slf4j.Slf4j;

/**
 * 重试Controller
 * 
 * @author liwenbin
 *
 */
@RestController
@Slf4j
@RequestMapping("/retry")
public class RetryController {

	@Autowired
	private IDistributeFailLogRepository distributeFailLogRepository;
	@Autowired
	private IAssetService assetService;

	@RequestMapping("/orders")
	public GlobalResponse retryOrders(String startTime, String endTime) {
		try {
			Page<DistributeFailLog> pageableFailAuditLog = distributeFailLogRepository.findByCreatedAtBetweenAndEnable(
					Timestamp.valueOf(startTime), Timestamp.valueOf(endTime), true, new PageRequest(0, 1000));
			List<DistributeFailLog> distributeFailLogList = pageableFailAuditLog.getContent();
			if (CollectionUtils.isNotEmpty(distributeFailLogList)) {
				log.info("分发失败查询数量为:{}", distributeFailLogList.size());
				pageableFailAuditLog.forEach(distributeFailLog -> {
					AssetForm assetForm = JSON.parseObject(distributeFailLog.getContext(), AssetForm.class);
					// 重新审核
					assetService.assetsIn(assetForm);

					distributeFailLog.setEnable(false);
					distributeFailLogRepository.save(distributeFailLog);
				});
			}
		} catch (Exception e) {
			log.error("资产分发失败订单重新分发异常!", e);
		}
		return GlobalResponse.success();
	}
}
