package com.quantgroup.asset.distribution.service.distribute;

import java.util.Map;

import com.quantgroup.asset.distribution.enums.funding.FundingResult;
import com.quantgroup.asset.distribution.model.form.AssetForm;
import com.quantgroup.asset.distribution.service.jpa.entity.Asset;

/**
 * 资产分发Service
 * @author liwenbin
 *
 */
public interface IAssetDistributeService {
	
	/**
	 * 资产开始分发
	 * @param assetForm
	 * @param asset
	 * @param startIndex 开始分发节点
	 * @param distributeLogo 1:初次分发或异常重试, 2:分发失败重新分发(预留)
	 */
	public void distribute(AssetForm assetForm, Asset asset, Map<String, Object> data);
	
	/**
	 * 接收fundingResult消息
	 * @param bizNo
	 * @param fundingResult
	 */
	public void receiveFundingResult(String bizNo, FundingResult fundingResult);
}
