package com.quantgroup.asset.distribution.service.jpa.entity;

import java.io.Serializable;
import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;

import lombok.Data;

/**
 * 审批日志表
 * @author liwenbin
 *
 */
@Table(name = "approval_log")
@Entity
@Data
public class ApprovalLog implements Serializable{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	@Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;
	
	@Column(name = "audit_type")
	private Integer auditType;
	
	@Column(name = "audit_target")
	private Integer auditTarget;
	
	@Column(name = "target_name")
	private String targetName;
	
	@Column(name = "proposer")
	private String proposer;
	
	@Column(name = "apply_time")
	private Timestamp applyTime;
	
	@Column(name = "auditor")
	private String auditor;
	
	@Column(name = "audit_time")
	private String auditTime;

	/**
	 * 0-待审批
	 * 1-审批通过
	 * 2-审批拒绝
	 * 3-撤销
	 */
	@Column(name = "audit_status")
	private Integer auditStatus;
	
	@Column(name = "pre_config_id")
	private Long preConfigId;
	
	@Column(name = "audit_config_id")
	private Long auditConfigId;
	
	@Column(name = "enable")
	private Boolean enable;
	
	@Column(name = "created_at")
	private Timestamp createdAt;
	
	@Column(name = "updated_at")
	private Timestamp updatedAt;
	
	@PrePersist
    public void prePersist() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        createdAt = timestamp;
        updatedAt = timestamp;
    }

    @PreUpdate
    public void preUpdate() {
        updatedAt = new Timestamp(System.currentTimeMillis());
    }
}
