/*
 * Copyright 2014-present Miyou tech inc. All Rights Reserved.
 */

package com.quantgroup.asset.distribution.exception;

import lombok.extern.slf4j.Slf4j;

/**
 * 系统使用Exception来进行Error Code处理。如果LogType为Error，
 * 代表这种Error不应该返回给客户端，应该统一打印出服务器端错误；
 * 如果是WARNING的话，就将对应的Exception Text返回给客户端。
 */
@Slf4j
public enum QGExceptionType {
    COMMON_SERVER_ERROR(1001, "系统异常，请稍后再试"),
    COMMON_ILLEGAL_STATE(1002, "断言错误"),
    COMMON_ILLEGAL_PARAM_TOAST(1003, "参数异常", "%s"),
    COMMON_AUTH_ERROR(1004, "系统异常，请稍后再试"),
    COMMON_ILLEGAL_PARAM(1010, "参数异常"),
    COMMON_THIRD_PARTY_TIMEOUT(1011, "第三方服务超时"),
    COMMON_ENUM_NOT_EXIST(1012,"枚举不存在"),
    COMMON_STRING_PARAM_IS_ALL_NULL(1013, "参数不能为空", "%s不能为空"),
    
    ASSET_IN_CODE_ERROR(2001, "资产入库code异常! uuid : %s, bizNo : %s, code : %s"),
	GET_DEC_ATTRIBUTE_VALUE_ERROR(2002, "获取决策资产属性值异常, uuid : %s, keys : %s"),
	ASSET_ATTRIBUTE_IS_EMPTY(2003, "%s资产属性值为空"),
	TRANSFORM_ASSET_ATTRIBUTE_ERROR(2004, "资产属性值转换成Map异常!"),
	
	DISTRIBUTE_RULE_CONFIG_PRIORITY_IS_NOT_UNIQUE(2021, "资产分发规则优先级不唯一"),
	RULE_CALC_ERROR(2022, "规则计算出现错误， expression : %s"),
	RULE_CALC_UNKNOW_ERROR(2023, "规则计算出现未知异常, expression : %s"),
	RULE_CALC_UNKNOW_RESULT(2024, "规则判断出现未知结果，请联系管理人员, expression : %s"),
	UNKNOW_RULE_TYPE(2025, "未知的规则类型, %s"),
	NO_DISTRIBUTE_NODE(2026, "未找到分发节点, uuid : %s, assetNo %s, records : %s"),
    RULE_EXPRESSION_IS_EMPTY(2027, "规则表达式未空"),
    RULE_IS_NOT_JSON(2028, "规则不是json,解析失败"),
    RULE_UNION_OPERATOR_NOT_EXIST(2029, "联合规则符不存在"),
    DATA_NOT_EXIST_FOR_RULE(2030, "规则数据不存在,key:%s, operator:%s, value:%s"),
    RULE_OPERATOR_IS_EMPTY(2031, "规则符为空"),
    RULE_DATA_IS_EMPTY(2032, "规则数据为空,key:%s, operator:%s, value:%s"),
    DATA_COMPARE_ERROR(2033, "数据比较出现错误"),
    RULE_OPERATOR_NOT_EXIST(2034, "规则符不存在"),
    CRATE_RULE_VO_ERROR(2035, "规则格式无法形成规则对象"),

	
	NOTIFY_FUND_SERVER_ERROR(2041, "通知资金系统失败, uuid : %s, bizNo : %s, assetNo : %s"),
	NOT_FOUND_FUND_SERVER_RESULT_BIZNO(2042, "未找到资金结果通知订单, bizNo : %s, status : %s"),
	NOTIFY_BUSINESS_FLOW_ERROR(2042, "通知业务流系统订单终态失败, bizNo : %s, status : %s"),
	
	// 资方模块错误信息
	GET_ALL_FUNDS_INFO_ERROR(3001, "拉取所有资方信息失败, res : %s"),
	NO_FUND_INFO_BEEN_HIT(3002, "未命中任何资方, bizChannel : %s, amount : %s, term : %s"),
	FUND_PRIORITY_IS_ERROR(3003, "资方优先级不符合要求, bizChannel : %s, amount : %s, term : %s"),
	NOT_FOUNT_CHANNEL_FUNDS_INFO(3004, "未找到渠道资方配置, 请检查; bizChannel : %s"),
	CHANNEL_FUND_CONFIG_GREATER_THAN_TOW(3005, "渠道资方有效配置大于2条，请检查; bizChannel : %s"),
	HIT_FUND_BUT_AMOUNT_OR_TERM_IS_EMPTY(3006, "命中资方但额度或期数为空, 请检查!"),

    GET_USER_INFO_ERROR(3007, "用户中心获取用户信息异常, uuid : %s"),
    USER_PHONE_NO_EMPTY(3008, "用户手机号为空"),
    USER_ID_NO_EMPTY(3009, "用户身份证为空"),
    USER_NAME_EMPTY(3010, "用户姓名为空"),
    GET_NIWODAI_TOKEN_ERROR(3011, "获取你我贷token异常"),
    NIWODAI_PRE_AUDIT_RESULAT_ERROR(3012, "你我贷准入接口返回结果异常, response : %s"),
    NIWODAI_INCOMING_RESULT_ERROR(3013, "你我贷进件返回结果异常, response : %s"),
    NIWODAI_INCOMING_AUDIT_RESULT_ERROR(3014, "你我贷进件审核返回结果异常, response : %s"),
    OCR_DATA_MISS(3015,"OCR信息数据缺失，请核查"),
    UNKNOW_AID_FUND_ID(3016, "未知的助贷资方, fundId : %s"),
    UNKNOW_PRE_AUDIT_TYPE(3017, "助贷资方未知的撞库方式, fundId : %s, preAuditType : %s"),
    USER_CONTACT_INFO_EMPTY(3018, "用户联系人方式为空, uuid : %s"),
    AID_COMMON_PRE_AUDIT_ERROR(3022, "助贷通用预审出现错误, uuid : %s, bizNo : %s, fundId : %s"),
    AID_COMMON_AUDIT_ERROR(3023, "助贷通用进件接口出现错误, uuid : %s, bizNo : %s, fundId : %s"),
    AID_COMMON_AUDIT_RESULT_ERROR(3024, "助贷回调URL或content内容错误, fundId : %s, fundProductId : %s, content : %s"),
    AID_COMMON_QUERY_AUDIT_RESULT_ERROR(3025, "助贷资方审核结果查询结果出现错误, uuid : %s, bizNo : %s, fundId : %s"),
    AID_COMMON_AUDIT_RESULT_ORDER_ERROR(3026, "通用助贷结果接收订单状态异常, orderNo : %s, fundId : %s, orderStatus : %s"),
    AID_COMMON_FUND_CONFIG_IS_EMPTY(3027, "未找到通用助贷资方信息配置, fundId : %s, fundProductId : %s"),
    ZS_DATA_TRANSFORM_ERROR(3028, "智数偿债能力转化出现错误"),

    USER_OCR_INFO_IS_EMPTY(3019, "用户OCR信息为空, uuid : %s"),
    LIVE_DATA_ERROR(3020, "活体数据获取失败, uuid : %s"),

    USER_LOAN_TYPE_IS_EMPTY(3021, "用户类型为空, uuid : %s");
	
	
	

    public int code;
    public String text;
    public String frontEndToastTemplate;

    QGExceptionType(int code, String text) {
        this.code = code;
        this.text = text;
        this.frontEndToastTemplate = text;
    }

    QGExceptionType(int code, String text, String frontEndToastTemplate) {
        this.code = code;
        this.text = text;
        this.frontEndToastTemplate = frontEndToastTemplate;
    }

    public static QGExceptionType fromCode(int code) {
        for (QGExceptionType exceptionType : QGExceptionType.values()) {
            if (exceptionType.code == code) {
                return exceptionType;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "error_code: " + code + ", text: " + text + ", frontEndToastTemplate: " + frontEndToastTemplate;
    }
}
