package com.quantgroup.asset.distribution.service.jpa.repository;

import org.springframework.data.jpa.repository.JpaRepository;

import com.quantgroup.asset.distribution.service.jpa.entity.AuthorityConfig;


/**
 * 权限认证Repository
 * @author liwenbin
 *
 */
public interface IAuthorityRepository extends JpaRepository<AuthorityConfig, Long>{
	
	/**
	 * 根据authKey和authPass查到配置
	 * @param authKey
	 * @param authPass
	 * @return
	 */
	public AuthorityConfig findByAuthKeyAndAuthPassAndEnableIsTrue(String authKey, String authPass);
}
