package com.quantgroup.asset.distribution.service.asset.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import com.quantgroup.asset.distribution.service.asset.IAssetAttributeExtendConfigService;
import com.quantgroup.asset.distribution.service.jpa.entity.AssetAttributeExtendConfig;
import com.quantgroup.asset.distribution.service.jpa.repository.IAssetAttributeExtendConfigRepository;

/**
 * 资产扩展属性配置Service
 * @author liwenbin
 *
 */
@Service
public class AssetAttributeExtendConfigServiceImpl implements IAssetAttributeExtendConfigService{

	@Autowired
	private IAssetAttributeExtendConfigRepository assetAttributeExtendConfigRepository;
	
	@Cacheable(value="cacheManager",key="'ASSET_1023A_ALL_ATTRIBUTE_EXTEND_CONFIG'")
	@Override
	public List<AssetAttributeExtendConfig> getAllExtendConfig() {
		return assetAttributeExtendConfigRepository.findByEnableIsTrue();
	}

	
	@CacheEvict(value = "cacheManager", key = "'ASSET_1023A_ALL_ATTRIBUTE_EXTEND_CONFIG'")
	@Override
	public void clearAllExtendConfigCache() {
		
	}
}
