package com.quantgroup.asset.distribution.service.jpa.entity;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Created by renfeng on 2019/7/17.
 */
@Entity
@Table(name="aid_loan_fund_config")
@Data
public class AidLoanFundConfig implements Serializable{

    private static final long serialVersionUID = -1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name="fund_no")
    private String fundNo;

    @Column(name="fund_name")
    private String fundName;

    @Column(name="fund_switch_state")
    private Integer fundSwitchState;

    @Column(name="fund_priority")
    private Integer fundPriority;

    @Column(name="fund_count_limit")
    private Integer fundCountLimit;

    @Column(name="fund_settlement_way")
    private Integer fundSettlementWay;

    @Column(name="fund_settlement_rate")
    private String fundSettlementRate;

    @Column(name="fund_id")
    private String fundId;

    @Column(name="fund_all_amount_limit")
    private String fundAllAmountLimit;

    @Column(name = "enable")
    private Boolean enable;

    @Column(name="created_by")
    private String createdBy;

    @Column(name="updated_by")
    private String updatedBy;

    @Column(name = "created_at")
    private Timestamp createdAt;

    @Column(name = "updated_at")
    private Timestamp updatedAt;


    @PrePersist
    public void prePersist() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        createdAt = timestamp;
        updatedAt = timestamp;
    }

    @PreUpdate
    public void preUpdate() {
        updatedAt = new Timestamp(System.currentTimeMillis());
    }
}
