package com.quantgroup.asset.distribution.util.ruleRelation;

import com.quantgroup.asset.distribution.enums.RuleOperator;
import com.quantgroup.asset.distribution.exception.QGException;
import com.quantgroup.asset.distribution.exception.QGExceptionType;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;

public class SetRelationUtil {

    public static <T> Range<T> getRange(String operator,String value){
        Class<?> clazz = getType(value);
        return null;
    }

    private static String getValue(String operator,String value){
        Class<?> clazz = getType(value);
        switch (RuleOperator.fromCode(operator)) {
            case Equal:
                return value;
            case NotEqual:
                if (clazz.isAssignableFrom(BigDecimal.class)) {
                    return new BigDecimal(value).add(new BigDecimal(1)).toString();
                }else if (clazz.isAssignableFrom(Boolean.class)){
                    return Boolean.toString(!Boolean.valueOf(value));
                }else {
                    if (value.length() == 1){
                        return String.valueOf((char) (value.charAt(0) + 1));
                    }else {
                        return value.substring(0,value.length() - 1) + String.valueOf((char) (value.charAt(value.length() -1 ) + 1));
                    }
                }
            case In:
                if (value.contains(",")){
                    List<String> list = Arrays.asList(value.split(","));
                    return list.get(RandomUtils.nextInt(0,list.size()-1));
                }else {
                    return value;
                }
            case NotIn:
                if (value.contains(",")){
                    List<String> list = Arrays.asList(value.split(","));
                    if (BigDecimal.class.isAssignableFrom(list.get(0).getClass())){
                        Integer num = 1;
                        while (list.contains(String.valueOf(num))){
                            num ++;
                        }
                        return num.toString();
                    }else {
                        String start = getValue(operator,list.get(0));
                        while (list.contains(start)){
                            start = getValue(operator,start);
                        }
                        return start;
                    }
                }else {
                    return value;
                }
            case LessThan:
                if (BigDecimal.class.isAssignableFrom(clazz)){
                    if (new BigDecimal(value).doubleValue() < 1 && new BigDecimal(value).doubleValue() > 0){
                        return new BigDecimal(value).divide(new BigDecimal(10),value.split(".")[1].length(), RoundingMode.HALF_UP).toString();
                    }else {
                        return new BigDecimal(value).subtract(new BigDecimal(1)).toString();
                    }
                }else {
                    throw new QGException(QGExceptionType.CRATE_RULE_VO_ERROR);
                }
            case GreaterThan:
                if (BigDecimal.class.isAssignableFrom(clazz)){
                    return new BigDecimal(value).add(new BigDecimal(1)).toString();
                }else {
                    throw new QGException(QGExceptionType.CRATE_RULE_VO_ERROR);
                }
            case LessThanOrEqual:
                return getValue("<",value);
            case GreaterThanOrEqual:
                return getValue(">",value);
            default:
                throw new QGException(QGExceptionType.RULE_OPERATOR_NOT_EXIST);
        }
    }

    private static Class<?> getType(String value){
        if (StringUtils.isNumeric(value)){
            return BigDecimal.class;
        }
        if ("true".equals(value) || "false".equals(value)){
            return Boolean.class;
        }
        return String.class;
    }
}
