package com.quantgroup.asset.distribution.model.form;

import java.io.Serializable;

import com.quantgroup.asset.distribution.service.jpa.entity.Asset;

import lombok.Data;

@Data
public class AssetForm implements Serializable{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private String code;
	
	private String msg;
	
	private String uuid;
	
	private String bizChannel;
	
	private String bizNo;
	
	private String bizType;
	
	private String auditResult;
	
	private String amount;
	
	private String deadLine;
	
	private String exData;
	
	private String otherInformation;
	
	private String financeProducts;
	
	private String assetNo;
	
	public Asset transToAsset() {
		Asset asset = new Asset();
		asset.setAssetNo(this.assetNo);
		asset.setBizNo(this.bizNo);
		asset.setUuid(this.uuid);
		asset.setBizChannel(this.bizChannel);
		asset.setFinanceProductType("0".equals(this.bizType) ? 0 : 1);
		asset.setAuditResult("true".equals(auditResult) ? 1 : 0);
		return asset;
	}
	
}
