package com.quantgroup.asset.distribution.service.niwodai.vo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

@Data
public class NiwodaiIncomingRequestVO implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 	资产渠道唯一标识当前申请信息的流水号 必填
     */
    private String orderId;
    /**
     * 借款人基本信息 必填
     */
    private NiwodaiCostant.UserInfo userInfo;
    /**
     * 借款申请信息 必填
     */
    private NiwodaiCostant.LoanInfo loanInfo;
    /**
     * 公司信息 必填
     */
    private NiwodaiCostant.CompnayInfo companyInfo;
    /**
     * 联系人信息 必填
     */
    private NiwodaiCostant.Contacts contacts;
    /**
     * 运营商数据 必填
     */
    private NiwodaiCostant.MnoData mnoData;
    /**
     * 手机安装App信息，JSON序列化后的字符串(需要GZIP压缩) 非必填
     */
    private String appListData;
    /**
     * 设备信息，JSON序列化后的字符串(需要GZIP压缩) 非必填
     */
    private String deviceInfo;
    /**
     * 人行征信授权信息  非必填
     */
    private NiwodaiCostant.CreditRefData creditRefData;

    /**
     * 风控数据对象
     */
    private NiwodaiCostant.RiskData channelRiskData;

    public Map<String,Object> toMap(){
        return JSONObject.parseObject(JSON.toJSONString(this));
    }

}
