package com.quantgroup.asset.distribution.service.jpa.entity;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * @author : Hyuk
 * @description : BizAssetOrder
 * @date : 2020/6/9 11:32 上午
 */
@Data
@Entity
@Table(name = "biz_asset_order")
public class BizAssetOrder implements Serializable {

    private static final long serialVersionUID = -1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "biz_channel")
    private String bizChannel;

    @Column(name = "biz_no")
    private String bizNo;

    @Column(name = "biz_type")
    private Integer bizType;

    @Column(name = "uuid")
    private String uuid;

    @Column(name = "context")
    private String context;

    @Column(name = "status")
    private Integer status;

    @Column(name = "enable")
    private Boolean enable;

    @Column(name = "created_at")
    private Timestamp createdAt;

    @Column(name = "updated_at")
    private Timestamp updatedAt;

    @PrePersist
    public void prePersist() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        createdAt = timestamp;
        updatedAt = timestamp;
    }

    @PreUpdate
    public void preUpdate() {
        updatedAt = new Timestamp(System.currentTimeMillis());
    }
}
