package com.quantgroup.asset.distribution.service.funding;

import com.quantgroup.asset.distribution.enums.funding.FundingResult;
import com.quantgroup.asset.distribution.service.jpa.entity.AidLoanFundRouteRecord;

import java.util.concurrent.TimeUnit;

import static com.quantgroup.asset.distribution.constant.RedisKeyConstants.FINISH_ROUTE_AID_FUND_KEY;

/**
 * Created by renfeng on 2019/7/17.
 */
public interface IAidFundRouteRecordService {


    /**
     * 资金分配结果通知
     *
     * @param bizNo
     * @param fundingResult
     */
    void fundingResultNotity(String bizNo, FundingResult fundingResult);


    /**
     * 保存主贷资金路由记录
     *
     * @param aidLoanFundRouteRecord
     */
    AidLoanFundRouteRecord saveAidLoanFundRouteRecord(AidLoanFundRouteRecord aidLoanFundRouteRecord);


    /**
     * 根据bizNo和fundId找路由记录
     *
     * @param bizNo
     * @param fundId
     * @return
     */
    AidLoanFundRouteRecord findByBizNoAndFundId(String bizNo, String fundId);


    /**
     * 更改助贷资金路由记录状态
     *
     * @param aidLoanFundRouteRecord
     * @param status
     * @return
     */
    AidLoanFundRouteRecord updateAidLoanFundRouteRecordStatus(AidLoanFundRouteRecord aidLoanFundRouteRecord, Integer status);
}
