package com.quantgroup.asset.distribution.service.newrule.pojo.funds;

import com.quantgroup.asset.distribution.service.newrule.third.AuditResponce;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * @author shihuajun
 * @date 2021/8/27 14:13
 * @ describing
 */
@Data
public class FilterResult {
    String financeProducts; //金融产品集


    public Map<String, String> get(AuditResponce responce) {
        return new HashMap<String, String>(32) {{
            put("code", responce.getCode().toString());
            put("msg", responce.getMsg());
            put("uuid", responce.getUuid());
            put("bizChannel", responce.getBizChannel());
            put("bizNo", responce.getBizNo());
            put("bizType", responce.getBizType());
            put("auditResult", responce.getAuditResult().toString());
            put("deadLine", responce.getDeadLine().toString());
            put("validity", responce.getValidity());
            put("openingDeadLine", responce.getOpeningDeadLine() == null ? null : String.valueOf(responce.getOpeningDeadLine()));
            put("openingValidity", responce.getOpeningValidity());
            put("otherInformation", responce.getOtherInformation());
            put("financeProducts", financeProducts);

            put("xycreditScore", String.valueOf(responce.getXycreditScore()));
            put("creditLevel", responce.getCreditLevel());
            put("callbackUrl", responce.getCallbackUrl());
            put("refuseReason", responce.getRefuseReason());

            put("amount", responce.getAmount());
            put("term", responce.getTerm());
            put("sceneId", String.valueOf(responce.getSceneId()));

            put("exData", responce.getExData());
            put("amountTermLimits", responce.getAmountTermLimits());
            put("fundRate", responce.getFundRate());
            put("amountRate", responce.getAmountRate());
            put("exportVccTag", responce.getExportVccTag());
            put("allowInstalment", responce.getAllowInstalment());
            put("allowInstalmentTerms", responce.getAllowInstalmentTerms());
            put("isWhiteBlackListHit", responce.getIsWhiteBlackListHit());
            put("isFuseModuleHit", responce.getIsFuseModuleHit());
            put("secondaryValidation",responce.getSecondaryValidation());
            if (StringUtils.isNotEmpty(responce.getQuotaPaymentAmount())) {
                put("quotaPaymentAmount", responce.getQuotaPaymentAmount());
            }
        }};
    }
}
