package com.quantgroup.asset.distribution.service.jpa.entity;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * @author : Hyuk
 * @description : FundModuleChannelFundConfigNew
 * @date : 2020/2/26 5:40 下午
 */
@Data
@Table(name = "fund_module_channel_fund_config_new")
@Entity
public class FundModuleChannelFundConfigNew implements Serializable {


    private static final long serialVersionUID = 1L;
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "biz_channel")
    private String bizChannel;

    @Column(name = "funds")
    private String funds;

    @Column(name = "remarks")
    private String remarks;

    @Column(name = "fund_ids")
    private String fundIds;

    @Column(name = "fund_limit_translate")
    private String fundLimitTranslate;

    @Column(name = "enable")
    private Boolean enable;

    @Column(name = "created_at")
    private Timestamp createdAt;

    @Column(name = "updated_at")
    private Timestamp updatedAt;

    @PrePersist
    public void prePersist() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        createdAt = timestamp;
        updatedAt = timestamp;
    }

    @PreUpdate
    public void preUpdate() {
        updatedAt = new Timestamp(System.currentTimeMillis());
    }
}
