package com.quantgroup.asset.distribution.service.route.impl;

import com.quantgroup.asset.distribution.model.entity.route.routerecord.RouteRecordQueryVo;
import com.quantgroup.asset.distribution.model.entity.route.routerecord.RouteRecordResultVo;
import com.quantgroup.asset.distribution.model.entity.route.whitelist.WhiteListResultVo;
import com.quantgroup.asset.distribution.service.jpa.entity.QRoutingRecordEntity;
import com.quantgroup.asset.distribution.service.jpa.entity.QWhiteListEntity;
import com.quantgroup.asset.distribution.service.jpa.entity.RoutingRecordEntity;
import com.quantgroup.asset.distribution.service.jpa.entity.WhiteListEntity;
import com.quantgroup.asset.distribution.service.jpa.repository.IRoutingRecordRepository;
import com.quantgroup.asset.distribution.service.route.IRouteRecordService;
import com.quantgroup.asset.distribution.util.AllRecords;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Service
public class RouteRecordServiceImpl implements IRouteRecordService {

    @Autowired
    private IRoutingRecordRepository routingRecordRepository;

    @Override
    public AllRecords queryPage(RouteRecordQueryVo routeRecordQueryVo) {
        //索引 和 每页大小   排序   条件
        BooleanExpression booleanExpression = Expressions.asBoolean(true).isTrue();

        if (!StringUtils.isEmpty(routeRecordQueryVo.getCreditNo())){
            booleanExpression =  booleanExpression.and(QRoutingRecordEntity.routingRecordEntity.creditNo.eq(routeRecordQueryVo.getCreditNo()));
        }
        if (!StringUtils.isEmpty(routeRecordQueryVo.getUuid())){
            booleanExpression =  booleanExpression.and(QRoutingRecordEntity.routingRecordEntity.uuid.eq(routeRecordQueryVo.getUuid()));
        }
        if (Objects.nonNull(routeRecordQueryVo.getStatus())){
            booleanExpression =  booleanExpression.and(QRoutingRecordEntity.routingRecordEntity.status.eq(routeRecordQueryVo.getStatus()));
        }
        if (Objects.nonNull(routeRecordQueryVo.getRoutedAtMin()) && Objects.nonNull(routeRecordQueryVo.getRoutedAtMax())){
            booleanExpression =  booleanExpression.and(QRoutingRecordEntity.routingRecordEntity.routedAt.between(routeRecordQueryVo.getRoutedAtMin(),routeRecordQueryVo.getRoutedAtMax()));
        }else if (Objects.nonNull(routeRecordQueryVo.getRoutedAtMin())){
            booleanExpression =  booleanExpression.and(QRoutingRecordEntity.routingRecordEntity.routedAt.after(routeRecordQueryVo.getRoutedAtMin()));
        }else if (Objects.nonNull(routeRecordQueryVo.getRoutedAtMax())){
            booleanExpression =  booleanExpression.and(QRoutingRecordEntity.routingRecordEntity.routedAt.before(routeRecordQueryVo.getRoutedAtMax()));
        }

        //1.查询条件，2.索引和每页的大小，3.排序根据某个字段进行排序
        //查询总条数
        long count = routingRecordRepository.count(booleanExpression);
        //查询数据
        Page<RoutingRecordEntity> plantPage = routingRecordRepository.findAll(booleanExpression, new PageRequest(routeRecordQueryVo.getOffset(), routeRecordQueryVo.getPageSize(), new Sort(Sort.Direction.DESC, "createdAt")));
        List<RoutingRecordEntity> routingRecordEntityList = new ArrayList<>();
        routingRecordEntityList = plantPage.getContent();
        List<RouteRecordResultVo> routeRecordResultVoList = new ArrayList<>();
        routingRecordEntityList.stream().forEach(routingRecordEntity -> {
            RouteRecordResultVo routeRecordResultVo = new RouteRecordResultVo();
            BeanUtils.copyProperties(routingRecordEntity, routeRecordResultVo);
            if (StringUtils.isEmpty(routeRecordResultVo.getRoutedResult())){
                routeRecordResultVo.setRoutedResult("无");
            }
            routeRecordResultVoList.add(routeRecordResultVo);
        });

        AllRecords allRecords = new AllRecords();
        allRecords.setPageIndex(routeRecordQueryVo.getPageIndex());
        allRecords.setPageSize(routeRecordQueryVo.getPageSize());
        allRecords.setDataList(routeRecordResultVoList);
        allRecords.setTotalNumber(count);
        allRecords.resetTotalNumber(count);
        return allRecords;
    }
}
