package com.quantgroup.asset.distribution.service.jpa.entity;

import javax.persistence.*;
import java.sql.Timestamp;
import java.util.Objects;

/**
 * @author shihuajun
 * @date 2021/9/2 15:02
 * @ describing
 */
@Entity
@Table(name = "channel_rule", schema = "asset-distribution", catalog = "")
public class ChannelRuleEntity {
    private long id;
    private long fundProductId;
    private long channelId;
    private Byte publishStatus;
    private long fundId;
    private long fundProId;
    private String fundName;
    private String fundType;
    private String orgType;
    private String businessType;
    private Integer creditResult;
    private String userTag;
    private String userLevel;
    private Integer priority;
    private Byte routeWait;
    private Byte enable;
    private Timestamp createdAt;
    private Timestamp updatedAt;

    @Id
    @Column(name = "id", nullable = false)
    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Basic
    @Column(name = "fund_product_id", nullable = false)
    public long getFundProductId() {
        return fundProductId;
    }

    public void setFundProductId(long fundProductId) {
        this.fundProductId = fundProductId;
    }

    @Basic
    @Column(name = "channel_id", nullable = false)
    public long getChannelId() {
        return channelId;
    }

    public void setChannelId(long channelId) {
        this.channelId = channelId;
    }

    @Basic
    @Column(name = "publish_status", nullable = true)
    public Byte getPublishStatus() {
        return publishStatus;
    }

    public void setPublishStatus(Byte publishStatus) {
        this.publishStatus = publishStatus;
    }

    @Basic
    @Column(name = "fund_id", nullable = false)
    public long getFundId() {
        return fundId;
    }

    public void setFundId(long fundId) {
        this.fundId = fundId;
    }

    @Basic
    @Column(name = "fund_pro_id", nullable = false)
    public long getFundProId() {
        return fundProId;
    }

    public void setFundProId(long fundProId) {
        this.fundProId = fundProId;
    }

    @Basic
    @Column(name = "fund_name", nullable = false, length = 100)
    public String getFundName() {
        return fundName;
    }

    public void setFundName(String fundName) {
        this.fundName = fundName;
    }

    @Basic
    @Column(name = "fund_type", nullable = false, length = 20)
    public String getFundType() {
        return fundType;
    }

    public void setFundType(String fundType) {
        this.fundType = fundType;
    }

    @Basic
    @Column(name = "org_type", nullable = false, length = 20)
    public String getOrgType() {
        return orgType;
    }

    public void setOrgType(String orgType) {
        this.orgType = orgType;
    }

    @Basic
    @Column(name = "business_type", nullable = false, length = 20)
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    @Basic
    @Column(name = "credit_result", nullable = false)
    public int getCreditResult() {
        return creditResult;
    }

    public void setCreditResult(int creditResult) {
        this.creditResult = creditResult;
    }

    @Basic
    @Column(name = "user_tag", nullable = false, length = 500)
    public String getUserTag() {
        return userTag;
    }

    public void setUserTag(String userTag) {
        this.userTag = userTag;
    }

    @Basic
    @Column(name = "user_level", nullable = false, length = 500)
    public String getUserLevel() {
        return userLevel;
    }

    public void setUserLevel(String userLevel) {
        this.userLevel = userLevel;
    }

    @Basic
    @Column(name = "priority", nullable = false)
    public int getPriority() {
        return priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Basic
    @Column(name = "route_wait", nullable = true)
    public Byte getRouteWait() {
        return routeWait;
    }

    public void setRouteWait(Byte routeWait) {
        this.routeWait = routeWait;
    }

    @Basic
    @Column(name = "enable", nullable = true)
    public Byte getEnable() {
        return enable;
    }

    public void setEnable(Byte enable) {
        this.enable = enable;
    }

    @Basic
    @Column(name = "created_at", nullable = false)
    public Timestamp getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(Timestamp createdAt) {
        this.createdAt = createdAt;
    }

    @Basic
    @Column(name = "updated_at", nullable = false)
    public Timestamp getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(Timestamp updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ChannelRuleEntity that = (ChannelRuleEntity) o;
        return id == that.id && fundProductId == that.fundProductId && channelId == that.channelId && fundId == that.fundId && fundProId == that.fundProId && creditResult == that.creditResult && priority == that.priority && Objects.equals(publishStatus, that.publishStatus) && Objects.equals(fundName, that.fundName) && Objects.equals(fundType, that.fundType) && Objects.equals(orgType, that.orgType) && Objects.equals(businessType, that.businessType) && Objects.equals(userTag, that.userTag) && Objects.equals(userLevel, that.userLevel) && Objects.equals(routeWait, that.routeWait) && Objects.equals(enable, that.enable) && Objects.equals(createdAt, that.createdAt) && Objects.equals(updatedAt, that.updatedAt);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, fundProductId, channelId, publishStatus, fundId, fundProId, fundName, fundType, orgType, businessType, creditResult, userTag, userLevel, priority, routeWait, enable, createdAt, updatedAt);
    }
}
