package com.quantgroup.asset.distribution.service.funding.impl;

import com.quantgroup.asset.distribution.constant.AidFundConstants;
import com.quantgroup.asset.distribution.exception.QGException;
import com.quantgroup.asset.distribution.exception.QGExceptionType;
import com.quantgroup.asset.distribution.model.form.AssetForm;
import com.quantgroup.asset.distribution.service.funding.IAidFundAssetService;
import com.quantgroup.asset.distribution.service.niwodai.INiwodaiAssetService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @author : Hyuk
 * @description : AidFundAssetServiceIMpl
 * @date : 2020/3/27 5:22 下午
 */
@Slf4j
@Service
public class AidFundAssetServiceImpl implements IAidFundAssetService {

    @Autowired
    private INiwodaiAssetService niwodaiAssetService;

    @Override
    public boolean preAudit(AssetForm assetForm, String fundId) {
        switch (fundId) {
            case AidFundConstants.FundId.NIWODAI : {
                return niwodaiAssetService.preAudit(assetForm.getUuid()).getPass().booleanValue();
            }
            default :
                throw new QGException(QGExceptionType.UNKNOW_AID_FUND_ID);
        }
    }

    @Override
    public boolean audit(AssetForm assetForm, Map<String, Object> data, Integer userLoanType, String fundId) {
        switch (fundId) {
            case AidFundConstants.FundId.NIWODAI : {
                return niwodaiAssetService.incoming(assetForm, data, userLoanType).getCode().equals(300007);
            }
            default :
                throw new QGException(QGExceptionType.UNKNOW_AID_FUND_ID);
        }
    }
}
