package com.quantgroup.asset.distribution.service.funding;

import com.quantgroup.asset.distribution.config.annotation.HandleException;
import com.quantgroup.asset.distribution.model.entity.fund.FundConfigCondition;
import com.quantgroup.asset.distribution.model.response.GlobalResponse;

import java.util.List;

/**
 * 资方模块Service
 * @author liwenbin
 *
 */
public interface IFundModuleService {
	
	/**
	 * 获取所有资方信息
	 * @return
	 */
	public GlobalResponse getAllFundsInfo();
	
	/**
	 * 获取资方配置所有条件类型， 以及对应的code
	 * @return
	 */
	public GlobalResponse getAllLimitType();
	
	/**
	 * 保存或更改渠道资方配置
	 * @return
	 */
	public GlobalResponse saveChannelFundConfig(Integer type, Long id, String bizChannel, String funds, String remarks,
			String auditor, String proposer);

	/**
	 * 保存或更改渠道资方配置(新)
	 * @param type
	 * @param id
	 * @param bizChannel
	 * @param funds
	 * @param remarks
	 * @param auditor
	 * @param proposer
	 * @return
	 */
	public GlobalResponse saveChannelFundConfigNew(Integer type, Long id, String bizChannel, String funds, String remarks,
												   String auditor, String proposer);
	
	/**
	 * 获取渠道资方配置信息
	 * @param bizChannel
	 * @param fundId
	 * @param pageNum
	 * @param pageSize
	 * @return
	 */
	public GlobalResponse getChannelFundConfigs(String bizChannel, Long fundId, Integer pageNum, Integer pageSize);


	/**
	 * 获取渠道资方配置信息(新)
	 * @param bizChannel
	 * @param fundId
	 * @param pageNum
	 * @param pageSize
	 * @return
	 */
	public GlobalResponse getChannelFundConfigsNew(String bizChannel, Long fundId, Integer pageNum, Integer pageSize);
	
	/**
	 * 获取审批列表
	 * @param targetName
	 * @param auditStatus
	 * @param auditType
	 * @param auditTarget
	 * @param applyStartTime
	 * @param applyEndTime
	 * @param user
	 * @param pageNum
	 * @param pageSize
	 * @return
	 */
	public GlobalResponse getAuditInfos(String targetName, Integer auditStatus, Integer auditType, Integer auditTarget, String applyStartTime, String applyEndTime, String user, Integer pageNum, Integer pageSize,Integer sortMode);
	
	/**
	 * 根据Id获取资方配置
	 * @param configId
	 * @return
	 */
	public GlobalResponse findChannelFundConfigById(Long configId);

	/**
	 * 根据id获取资方配置(新)
	 * @param configId
	 * @return
	 */
	public GlobalResponse findChannelFundConfigNewById(Long configId);
	
	/**
	 * 审批接口
	 * @param id 审理log id
	 * @param auditStatus
	 * @return
	 */
	public GlobalResponse audit(Long id, Integer auditStatus);

	GlobalResponse getAllConditionsOfFundConfig(Long configId);

	GlobalResponse simulationCases(List<FundConfigCondition> configConditions,Long configId);
}
