package com.quantgroup.asset.distribution.config.web;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import com.quantgroup.asset.distribution.config.web.interceptor.AuthorityInterceptor;

/**
 * 
 * @author liwenbin
 *
 */
@Configuration
@Slf4j
public class WebMvcConfigure extends WebMvcConfigurerAdapter {
	
	@Autowired
	private AuthorityInterceptor authorityInterceptor;
	
	/**
	 * 添加拦截器
	 */
	@Override
	public void addInterceptors(InterceptorRegistry registry) {
		registry.addInterceptor(authorityInterceptor)
				.addPathPatterns("/biz/**");
	}

	@Override
	public void addCorsMappings(CorsRegistry registry) {
		registry.addMapping("/**")
				.allowedOrigins("*")
				.allowedMethods("HEAD", "GET", "POST")
				.allowedHeaders("X-Auth-Token", "Origin", "No-Cache", "X-Requested-With", "If-Modified-Since", "Pragma", "Last-Modified", "Cache-Control", "Expires", "Content-Type", "Authorization")
				.allowCredentials(true)
				.maxAge(3600);
	}
}