package com.quantgroup.asset.distribution.service.funding.impl;

import cn.quantgroup.motan.bean.UserInfo;
import cn.quantgroup.motan.vo.UserSysResult;
import cn.quantgroup.user.IUserSdkService;
import cn.quantgroup.user.UserSdkServiceFactory;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.lkb.data.hbase.dataservice.verify.OCRIdCardDataService;
import com.lkb.data.hbase.row.verify.OCRIdCardRow;
import com.quantgroup.asset.distribution.constant.CodeConstants;
import com.quantgroup.asset.distribution.constant.aid.PreAuditTypeConstants;
import com.quantgroup.asset.distribution.enums.user.EducationEnum;
import com.quantgroup.asset.distribution.enums.user.IncomeRangeEnum;
import com.quantgroup.asset.distribution.enums.user.MaritalStatusEnum;
import com.quantgroup.asset.distribution.enums.user.OccupationEnum;
import com.quantgroup.asset.distribution.exception.QGException;
import com.quantgroup.asset.distribution.exception.QGExceptionType;
import com.quantgroup.asset.distribution.exception.QGPreconditions;
import com.quantgroup.asset.distribution.model.entity.OcrIdCardEntity;
import com.quantgroup.asset.distribution.model.entity.aid.*;
import com.quantgroup.asset.distribution.model.entity.live.TencentLiveEntity;
import com.quantgroup.asset.distribution.model.entity.user.SDKUserInfo;
import com.quantgroup.asset.distribution.model.entity.user.UserAddressInfo;
import com.quantgroup.asset.distribution.model.entity.user.UserContactInfo;
import com.quantgroup.asset.distribution.model.form.AssetForm;
import com.quantgroup.asset.distribution.model.response.MiddleOfficeResponse;
import com.quantgroup.asset.distribution.service.aid.IAidFundInfoConfigService;
import com.quantgroup.asset.distribution.service.funding.IAidAssetCommonService;
import com.quantgroup.asset.distribution.service.httpclient.IHttpService;
import com.quantgroup.asset.distribution.service.jpa.entity.AidFundInfoConfig;
import com.quantgroup.asset.distribution.service.jpa.entity.Asset;
import com.quantgroup.asset.distribution.service.niwodai.vo.IdCardA;
import com.quantgroup.asset.distribution.service.niwodai.vo.IdCardB;
import com.quantgroup.asset.distribution.service.user.IUserCenterService;
import com.quantgroup.asset.distribution.util.MD5Util;
import com.quantgroup.asset.distribution.util.OcrUtils;
import com.quantgroup.asset.distribution.util.RsaUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.PostConstruct;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author : Hyuk
 * @description : AidAssetCommonServiceImpl
 * @date : 2020/6/4 6:32 下午
 */
@Slf4j
@Service
public class AidAssetCommonServiceImpl implements IAidAssetCommonService {


    //TODO
    @Value("${opearotr.server.domain}")
    private String operatorDomain;

    @Autowired
    private IAidFundInfoConfigService aidFundInfoConfigService;
    @Autowired
    private IHttpService httpService;
    @Autowired
    private IUserCenterService userCenterService;

    @Override
    public boolean preAudit(AssetForm assetForm, String fundId, String fundProductId, Map<String, Object> data) {
        try {
            AidFundInfoConfig aidFundInfoConfig = aidFundInfoConfigService.findAidFundInfo(fundId, fundProductId);
            String preAuditUrl = aidFundInfoConfig.getPreAuditUrl();
            int preAuditType = PreAuditTypeConstants.PHONE_NO_OR_ID_CARD_NO_MD5;
            Map<String, String> requestParams = getPreAuditParams(assetForm.getUuid(), fundId, fundProductId, preAuditType);
            MiddleOfficeResponse response = request(preAuditUrl, JSON.toJSONString(requestParams), aidFundInfoConfig.getPrivateKey(), aidFundInfoConfig.getPublicKey());
            if (CodeConstants.SUCCESS.equals(response.getCode())) {
                return true;
            }
            return false;
        } catch (Exception e) {
            log.error("助贷资方通用预审接口出现错误, uuid : {}, bizNo : {}, fundId : {}", assetForm.getUuid(), assetForm.getBizNo(), fundId, e);
            throw new QGException(QGExceptionType.AID_COMMON_PRE_AUDIT_ERROR, assetForm.getUuid(), assetForm.getBizNo(), fundId);
        }
    }

    @Override
    public boolean audit(AssetForm assetForm, Asset asset, Map<String, Object> data, String fundId, String fundProductId) {
        try {
            AidFundInfoConfig aidFundInfoConfig = aidFundInfoConfigService.findAidFundInfo(fundId, fundProductId);
            String requestURL = aidFundInfoConfig.getAuditUrl();

            // 用户中心相关信息, 这里不可能为空，不然预审就拦截住了
            UserInfo userInfo = userCenterService.getUserInfoByUuid(assetForm.getUuid());
            SDKUserInfo sdkUserInfo = userCenterService.getSDKUserExtInfo(userInfo.getPhoneNo(), assetForm.getUuid());
            QGPreconditions.checkArgument(sdkUserInfo != null, QGExceptionType.GET_USER_INFO_ERROR, assetForm.getUuid());

            AidIncomingEntity aidIncomingEntity = new AidIncomingEntity(assetForm.getBizNo());
            aidIncomingEntity.setUserInfo(createdAidUserInfo(userInfo, sdkUserInfo, assetForm.getUuid()));
            aidIncomingEntity.setContactsInfo(createdAidContactsInfo(sdkUserInfo.getContactList(), assetForm.getUuid()));
            aidIncomingEntity.setLoanInfo(createdAidLoanInfo(assetForm.getUuid()));
            aidIncomingEntity.setRiskInfo(createdAidRiskInfo(assetForm.getUuid(), data));

            MiddleOfficeResponse response = request(requestURL, JSON.toJSONString(aidIncomingEntity), aidFundInfoConfig.getPrivateKey(), aidFundInfoConfig.getPublicKey());
            if (CodeConstants.SUCCESS.equals(response.getCode())) {
                return true;
            }
            return false;
        } catch (Exception e) {
            log.error("助贷资方通用进件接口出现错误, uuid : {}, bizNo : {}, fundId : {}", assetForm.getUuid(), assetForm.getBizNo(), fundId, e);
            throw new QGException(QGExceptionType.AID_COMMON_AUDIT_ERROR, assetForm.getUuid(), assetForm.getBizNo(), fundId);
        }

    }

    @Override
    public void auditResult(AssetForm assetForm, Asset asset, String fundId, String fundProductId) {
        try {
            String url = "https://sit02-third.n-orange.com/webservice/api/lhp/v1/credit/applyResult";
            AidFundInfoConfig aidFundInfoConfig = aidFundInfoConfigService.findAidFundInfo(fundId, fundProductId);
            Map<String, String> params = new HashMap<>();
            params.put("orderNo", assetForm.getBizNo());
            MiddleOfficeResponse response = request(url, JSON.toJSONString(params), aidFundInfoConfig.getPrivateKey(), aidFundInfoConfig.getPublicKey());
        } catch (Exception e) {
            log.error("111", e);
        }
    }

    /**
     * 获取撞库接口Map
     * @param uuid
     * @param fundId
     * @param fundProductId
     * @param preAuditType
     * @return
     */
    public Map<String, String> getPreAuditParams(String uuid, String fundId, String fundProductId, int preAuditType) {
        UserInfo userInfo = userCenterService.getUserInfoByUuid(uuid);
        if (userInfo == null){
            log.error("通用助贷资方推送获取用户中心信息失败 uuid : {}",uuid, fundId, fundProductId, preAuditType);
            throw new QGException(QGExceptionType.GET_USER_INFO_ERROR, uuid);
        }

        String name = userInfo.getName();
        String idNo = userInfo.getIdNo();
        String phoneNo = userInfo.getPhoneNo();
        if (StringUtils.isAnyEmpty(name, idNo, phoneNo)) {
            log.info("通用助贷资方推送，用户三要素部分缺失, fundId : {}, fundProductId : {}, uuid : {}");
            throw new QGException(QGExceptionType.GET_USER_INFO_ERROR, uuid);
        }

        Map<String, String> requestParams = new HashMap<>();
        requestParams.put("type", String.valueOf(preAuditType));
        switch (preAuditType) {
            case PreAuditTypeConstants.PHONE_NO_MD5 : {
                requestParams.put("phoneNo", MD5Util.md5(phoneNo));
                break;
            }
            case PreAuditTypeConstants.ID_CARD_MD5 : {
                requestParams.put("idCardNo", MD5Util.md5(idNo.replaceAll("x", "X")));
                break;
            }
            case PreAuditTypeConstants.PHONE_NO_ID_CARD_MD5 : {
                String param = phoneNo + idNo.replaceAll("x", "X");
                requestParams.put("exData", MD5Util.md5(param));
                break;
            }
            case PreAuditTypeConstants.PHONE_NO_OR_ID_CARD_NO_MD5 : {
                requestParams.put("phoneNo", MD5Util.md5(phoneNo));
                requestParams.put("idCardNo", MD5Util.md5(idNo.replaceAll("x", "X")));
                requestParams.put("name", name);
                break;
            }
            default:
                throw new QGException(QGExceptionType.UNKNOW_PRE_AUDIT_TYPE, fundId, preAuditType);
        }
        return requestParams;
    }

    /**
     * 创建助贷通用UserInfo
     * @param userInfo
     * @param sdkUserInfo
     * @param uuid
     * @return
     */
    private AidUserInfo createdAidUserInfo(UserInfo userInfo, SDKUserInfo sdkUserInfo, String uuid) {
        AidUserInfo aidUserInfo = new AidUserInfo();

        List<OCRIdCardRow> rows = OCRIdCardDataService.get(uuid);
        QGPreconditions.checkArgument(!CollectionUtils.isEmpty(rows), QGExceptionType.FUND_PRIORITY_IS_ERROR, uuid);
        OcrIdCardEntity ocrIdCardEntity = OcrUtils.transForm(rows.get(0));

        aidUserInfo.setName(ocrIdCardEntity.getIdCardA().getName());
        aidUserInfo.setIdCardNo(ocrIdCardEntity.getIdCardA().getCitizen_id().replaceAll("x", "X"));
        aidUserInfo.setPhoneNo(userInfo.getPhoneNo());

        aidUserInfo.setEducation(sdkUserInfo.getEducationEnum());
        aidUserInfo.setOccupation(sdkUserInfo.getOccupationEnum());
        aidUserInfo.setIncome(sdkUserInfo.getIncomeRangeEnum());
        aidUserInfo.setMaritalStatus(sdkUserInfo.getMarryStatus());

        UserAddressInfo addressInfo = sdkUserInfo.getAddressList().get(0);
        aidUserInfo.setAddress(addressInfo.getAddressDetail());
        aidUserInfo.setValidDateBegin(ocrIdCardEntity.getIdCardB().getValid_date_begin());
        aidUserInfo.setValidDateEnd(ocrIdCardEntity.getIdCardB().getValid_date_end());
        aidUserInfo.setIdCardAddress(ocrIdCardEntity.getIdCardA().getAddress());
        aidUserInfo.setGender("男".equals(ocrIdCardEntity.getIdCardA().getGender()) ? "1" : "2");
        aidUserInfo.setNation(ocrIdCardEntity.getIdCardA().getNation());
        aidUserInfo.setAgency(ocrIdCardEntity.getIdCardB().getAgency());
        aidUserInfo.setIdCardBaseContentA(ocrIdCardEntity.getIdCardBaseContentA());
        aidUserInfo.setIdCardBaseContentB(ocrIdCardEntity.getIdCardBaseContentB());
        aidUserInfo.setLivePhotoContent(ocrIdCardEntity.getLivePhotoContent());

        // 0-腾讯, 增加了就去写个枚举
        aidUserInfo.setLiveType(0);
        TencentLiveEntity tencentLiveEntity = getTencentLiveEntity(uuid);
        aidUserInfo.setLiveResult(tencentLiveEntity);
        aidUserInfo.setEmail(sdkUserInfo.getEmail());
        return aidUserInfo;
    }

    /**
     * 创建助贷通用联系人信息
     * @param uuid
     * @return
     */
    private AidContactsInfo createdAidContactsInfo(List<UserContactInfo> contactInfoList, String uuid) {
        QGPreconditions.checkArgument(!CollectionUtils.isEmpty(contactInfoList), QGExceptionType.USER_CONTACT_INFO_EMPTY, uuid);

        AidContactsInfo aidContactsInfo = new AidContactsInfo();
        aidContactsInfo.setFirstName(contactInfoList.get(0).getName());
        aidContactsInfo.setFirstMobile(contactInfoList.get(0).getPhoneNo());
        aidContactsInfo.setFirstRelation(contactInfoList.get(0).getRelationName());

        if (contactInfoList.size() > 1) {
            aidContactsInfo.setSecondName(contactInfoList.get(1).getName());
            aidContactsInfo.setSecondMobile(contactInfoList.get(1).getPhoneNo());
            aidContactsInfo.setSecondRelation(contactInfoList.get(1).getRelationName());
        }
        return aidContactsInfo;
    }

    /**
     * 创建助贷通用借款申请相关信息
     * @param uuid
     * @return
     */
    private AidLoanInfo createdAidLoanInfo(String uuid) {
        return null;
    }

    /**
     * 创建助贷通用风控信息
     * @param uuid
     * @param data
     * @return
     */
    private AidRiskInfo createdAidRiskInfo(String uuid, Map<String, Object> data) {
        // TODO
        return AidRiskInfo.builder()
                .label(1)
                .qgScore3(new BigDecimal("0.3484291211465728"))
                .qgScore5(new BigDecimal("0.4391283915198491"))
                .qgDebtPayingScore(new BigDecimal("42"))
                .qgRiskLevelPhone("B1")
                .qgRiskLevelIdNo("B1")
                .build();
    }

    /**
     * 获取腾讯活体结果
     * @param uuid
     * @return
     */
    private TencentLiveEntity getTencentLiveEntity(String uuid) {
        String url = operatorDomain + "/auth-center/ex/face/getOcrData.json";
        Map<String, String> params = new HashMap<>();
        params.put("uuid", uuid);
        // 以后增加活体类型记得增加枚举
        params.put("liveType", "teng_xun");

        String result = httpService.post(url, params);
        JSONObject data = JSON.parseObject(result);
        QGPreconditions.checkArgument(data != null , QGExceptionType.LIVE_DATA_ERROR, uuid);

        if ("0".equals(data.getString("code")) && "0".equals(data.getString("business_code"))) {
            return JSON.parseObject(data.getString("data"), TencentLiveEntity.class);
        }
        return null;
    }

    /**
     * 创建包装助贷资方对象
     * @param data
     * @param privateKey
     * @return
     */
    private String createRequestParams(String data, String privateKey) throws Exception {
        AidRsaParams aidRsaParams = AidRsaParams.builder()
                                                .appId("1050")
                                                .content(RsaUtils.encryptByPrivateKey(data, privateKey))
                                                .build();
        return JSON.toJSONString(aidRsaParams);
    }

    /**
     * 通用请求，包装加密和解密
     * @param url
     * @param data
     * @return
     */
    private MiddleOfficeResponse request(String url, String data, String privateKey, String publicKey) throws Exception {
        String text = httpService.postJson(url, createRequestParams(data, privateKey));
        AidRsaParams aidRsaParams = JSON.parseObject(text, AidRsaParams.class);
        String result = RsaUtils.decryptByPublicKey(aidRsaParams.getContent(), publicKey);
        log.info("通用助贷资方请求结束, url : {}, data : {}, result : {}", url, data, result);
        MiddleOfficeResponse response = JSON.parseObject(result, MiddleOfficeResponse.class);
        return response;
    }

    public static void main(String[] args) {
        String text = "{\"content\":\"cCdElnqK1w3GRfuz9seRmo7fY3iJQNFoDRvpBdg8maIhJ/IzOBQQdeqxhxT14cJ1oT/4pHazsTNK\\r\\ngmGARtFR1SPi9kSa7/MdVTibOp1p+rzbe1tVHSL/GFuQPgglgQakZ1EnoiLj5jTwRBA29n4EgN4+\\r\\nalq95YC1Y+Rq1k4RyrU=\\r\\n\"}";
        AidRsaParams aidRsaParams = JSON.parseObject(text, AidRsaParams.class);
        System.out.println(aidRsaParams);
    }
}
