package com.quantgroup.asset.distribution.service.funding;

import com.quantgroup.asset.distribution.model.form.AssetForm;
import com.quantgroup.asset.distribution.service.jpa.entity.Asset;

import java.util.Map;

/**
 * @author : Hyuk
 * @description : IAidAssetCommonService
 * @date : 2020/6/4 6:28 下午
 */
public interface IAidAssetCommonService {

    /**
     * 助贷资方通用预审接口
     * @param assetForm
     * @param fundId
     * @param fundProductId
     * @param data
     * @return
     */
    boolean preAudit(AssetForm assetForm, String fundId, String fundProductId, Map<String, Object> data);

    /**
     * 助贷资方通用审核接口
     * @param assetForm
     * @param asset
     * @param data
     * @param fundId
     * @param fundProductId
     * @return
     */
    boolean audit(AssetForm assetForm, Asset asset, Map<String, Object> data, String fundId, String fundProductId);

    /**
     * 审核结果查询
     * @param assetForm
     * @param asset
     * @param fundId
     * @param fundProductId
     */
    void auditResult(AssetForm assetForm, Asset asset, String fundId, String fundProductId);


}
