package com.quantgroup.asset.distribution.enums.response;

import lombok.Getter;

/**
 * 权限认证返回错误信息
 * 102X
 * @author liwenbin
 *
 */
public enum AuthorityResponse implements GlobalResponseEnum{
	
	AS_AUTH_KEY_IS_EMPTY(1021, "as_auth_key不能为空"),
	AS_AUTH_PASS_IS_EMPTY(1022, "as_auth_pass不能为空"),
	AS_AUTH_KEY_AND_PASS_IS_NOT_EXIST(1023, "权限认证失败, 请检查!");
	
	
	@Getter
	private int code;
	@Getter
	private String businessCode;
	@Getter
	private String msg;
	@Getter
	private Object body;
	
	AuthorityResponse(int code, String msg) {
		this.code = code;
		this.businessCode = null;
		this.msg = msg;
		this.body = null;
	}
	
	AuthorityResponse(int code, String businessCode, String msg) {
		this.code = code;
		this.businessCode = businessCode;
		this.msg = msg;
	}
}
