package com.quantgroup.asset.distribution.util.aid;

import com.quantgroup.asset.distribution.constant.aid.AidAuditResultConstants;
import com.quantgroup.asset.distribution.factory.Operation;
import com.quantgroup.asset.distribution.model.entity.aid.AidAuditResultEntity;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * @author : Hyuk
 * @description : AidAuditResultCheckUtils
 * @date : 2020/7/9 12:41 上午
 */
public class AidAuditResultCheckUtils {

    private static final Map<Integer, Operation<AidAuditResultEntity>> map = new HashMap<>();

    static {
        map.put(AidAuditResultConstants.AUDITING, (aidAuditResultEntity) -> checkOrderNo(aidAuditResultEntity));
        map.put(AidAuditResultConstants.REJECT, (aidAuditResultEntity) -> checkOrderNo(aidAuditResultEntity));
        map.put(AidAuditResultConstants.PASS, (aidAuditResultEntity) -> {
            if (checkOrderNo(aidAuditResultEntity) && aidAuditResultEntity.getAmount() != null &&
                    aidAuditResultEntity.getTerm() != null && aidAuditResultEntity.getDeadLine() != null) {
                return true;
            }
            return false;
        });
    }

    private static boolean checkOrderNo(AidAuditResultEntity aidAuditResultEntity) {
        return StringUtils.isNotEmpty(aidAuditResultEntity.getOrderNo());
    }


    public static final boolean check(AidAuditResultEntity aidAuditResultEntity) {
        return Optional.ofNullable(map.get(aidAuditResultEntity.getAuditResult())).orElse((aidAuditResultEntity1 -> false)).check(aidAuditResultEntity);
    }
}
