package com.quantgroup.asset.distribution.model.entity.aid;

import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author : Hyuk
 * @description : AidRiskInfo
 * @date : 2020/6/5 3:51 下午
 */
@Builder
@Data
public class AidRiskInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    private int label;

    /**
     * 量子分3
     */
    private BigDecimal qgScore3;

    /**
     * 量子分5
     */
    private BigDecimal qgScore5;

    /**
     * 偿债能力评分
     */
    private BigDecimal qgDebtPayingScore;

    /**
     * 量子风险等级手机号命中
     */
    private String qgRiskLevelPhone;

    /**
     * 量子风险等级身份证号命中
     */
    private String qgRiskLevelIdNo;

    public AidRiskInfo() {}

    public AidRiskInfo(int label, BigDecimal qgScore3, BigDecimal qgScore5, BigDecimal qgDebtPayingScore, String qgRiskLevelPhone, String qgRiskLevelIdNo) {
        super();
        this.label = label;
        this.qgScore3 = qgScore3;
        this.qgScore5 = qgScore5;
        this.qgDebtPayingScore = qgDebtPayingScore;
        this.qgRiskLevelPhone = qgRiskLevelPhone;
        this.qgRiskLevelIdNo = qgRiskLevelIdNo;
    }
}
