package com.quantgroup.asset.distribution.service.jpa.entity;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * @author : Hyuk
 * @description : AidFundInfoConfig
 * @date : 2020/6/9 8:13 下午
 */
@Entity
@Table(name="aid_fund_info_config")
@Data
public class AidFundInfoConfig implements Serializable {

    private static final long serialVersionUID = -1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "fund_id")
    private String fundId;

    @Column(name = "fund_product_id")
    private String fundProductId;

    @Column(name = "pre_audit_type")
    private Integer preAuditType;

    @Column(name = "private_key")
    private String privateKey;

    @Column(name = "public_key")
    private String publicKey;

    @Column(name = "pre_audit_url")
    private String preAuditUrl;

    @Column(name = "audit_url")
    private String auditUrl;

    @Column(name = "enable")
    private Boolean enable;

    @Column(name = "created_at")
    private Timestamp createdAt;

    @Column(name = "updated_at")
    private Timestamp updatedAt;

    @PrePersist
    public void prePersist() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        createdAt = timestamp;
        updatedAt = timestamp;
    }

    @PreUpdate
    public void preUpdate() {
        updatedAt = new Timestamp(System.currentTimeMillis());
    }
}
