package com.quantgroup.asset.distribution.service.niwodai.impl;

import cn.quantgroup.motan.bean.UserInfo;
import cn.quantgroup.motan.vo.UserSysResult;
import cn.quantgroup.user.IUserSdkService;
import cn.quantgroup.user.UserSdkServiceFactory;
import com.alibaba.fastjson.JSON;
import com.lkb.data.hbase.dataservice.verify.OCRIdCardDataService;
import com.lkb.data.hbase.row.verify.OCRIdCardRow;
import com.quantgroup.asset.distribution.exception.QGException;
import com.quantgroup.asset.distribution.exception.QGExceptionType;
import com.quantgroup.asset.distribution.service.niwodai.INiwodaiAssetService;
import com.quantgroup.asset.distribution.service.niwodai.INiwodaiService;
import com.quantgroup.asset.distribution.service.niwodai.vo.*;
import com.quantgroup.asset.distribution.util.AddressResolutionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Service
public class NiwodaiAssetServiceImpl implements INiwodaiAssetService {

    @Autowired
    @Qualifier("httpClient")
    private CloseableHttpClient httpClient;
    @Autowired
    private INiwodaiService niwodaiService;
    @Value("${user.sdk.url}")
    private String userSysUrl;
    private IUserSdkService userSdkService;

    private static String[] companyNames = new String[]{"1","2"};

    @PostConstruct
    private void init() {
        userSdkService = UserSdkServiceFactory.generateSDKService(userSysUrl, httpClient);
    }

    public NiwodaiIncomingResponseVO incoming(String uuid, String orderId, String amount, Integer term,
                                              NiwodaiCostant.MnoData mnoData,NiwodaiCostant.Contacts contacts) {
        List<OCRIdCardRow> list = OCRIdCardDataService.get(uuid);
        if (CollectionUtils.isEmpty(list)) {
            throw new QGException("没有相关用户信息", QGExceptionType.COMMON_ILLEGAL_PARAM);
        }
        OCRIdCardRow ocrIdCardRow = list.get(0);
        UserSysResult<UserInfo> userInfoByUuid = userSdkService.findUserInfoByUuid(uuid);
        IdCardA idCardA = JSON.parseObject(ocrIdCardRow.getIdCardContentA(), IdCardA.class);
        IdCardB idCardB = JSON.parseObject(ocrIdCardRow.getIdCardContentB(), IdCardB.class);
        NiwodaiIncomingRequestVO vo = new NiwodaiIncomingRequestVO();
        vo.setOrderId(orderId);
        NiwodaiCostant.UserInfo userInfo = new NiwodaiCostant.UserInfo();
        userInfo.setRealName(idCardA.getName());
        userInfo.setIdcardNumber(idCardA.getCitizen_id());
        userInfo.setPhone(userInfoByUuid.getData().getPhoneNo());
        userInfo.setMaritalStatus(NiwodaiCostant.MaritalStatus.UNMARRIED.name());
        userInfo.setGender("男".equals(idCardA.getGender()) ? NiwodaiCostant.Gender.MALE.name() : NiwodaiCostant.Gender.FEMALE.name());
        userInfo.setEducation(NiwodaiCostant.EducationalBackground.JUNIOR_SCHOOL_AND_BELOW.name());
        userInfo.setOccupation(NiwodaiCostant.Occupation.WORKER.name());
        userInfo.setIdcardValidity(idCardB.getValid_date_end());
        userInfo.setIdcardFront(ocrIdCardRow.getIdCardBaseContentA());
        userInfo.setIdcardBack(ocrIdCardRow.getIdCardBaseContentB());
        userInfo.setBioPhoto(ocrIdCardRow.getLivePhotoContent());
        userInfo.setImageType("BASE64");
        Map<String,String> addressMap = AddressResolutionUtil.addressResolution(userInfo.getAddress());
        userInfo.setProvince(addressMap.get("province"));
        userInfo.setCity(addressMap.get("city"));
        userInfo.setAddress(idCardA.getAddress());
        userInfo.setIndustry(NiwodaiCostant.Industry.ENTERTAINMENT.name());
        userInfo.setIncome(NiwodaiCostant.Income.FOUR.name());
        userInfo.setIncomeType(NiwodaiCostant.IncomeType.SALARY.name());
        userInfo.setDebt(NiwodaiCostant.Debt.ZERO.name());
        vo.setUserInfo(userInfo);
        NiwodaiCostant.LoanInfo loanInfo = new NiwodaiCostant.LoanInfo();
        loanInfo.setAmount(new BigDecimal(amount));
        loanInfo.setTerm(term);
        loanInfo.setPurpose(NiwodaiCostant.Purpose.CONSUMPTION.name());
        vo.setLoanInfo(loanInfo);
        vo.setContacts(contacts);
        NiwodaiCostant.CompnayInfo compnayInfo = new NiwodaiCostant.CompnayInfo();
        compnayInfo.setName(randomCompanyName());
        compnayInfo.setAddress(userInfo.getProvince()+userInfo.getCity()+compnayInfo.getName());
        compnayInfo.setCity(userInfo.getCity());
        compnayInfo.setProvince(userInfo.getProvince());
        vo.setCompanyInfo(compnayInfo);
        vo.setMnoData(mnoData);
        return niwodaiService.incoming(vo);
    }

    private static String randomCompanyName(){
        int index = (int) (Math.random() * companyNames.length);
        return companyNames[index];

    }

}
