/*
 * Copyright 2014-present Miyou tech inc. All Rights Reserved.
 */

package com.quantgroup.asset.distribution.exception;

import lombok.extern.slf4j.Slf4j;

/**
 * 系统使用Exception来进行Error Code处理。如果LogType为Error，
 * 代表这种Error不应该返回给客户端，应该统一打印出服务器端错误；
 * 如果是WARNING的话，就将对应的Exception Text返回给客户端。
 */
@Slf4j
public enum QGExceptionType {
    COMMON_SERVER_ERROR(1001, "系统异常，请稍后再试"),
    COMMON_ILLEGAL_STATE(1002, "断言错误"),
    COMMON_ILLEGAL_PARAM_TOAST(1003, "参数异常", "%s"),
    COMMON_AUTH_ERROR(1004, "系统异常，请稍后再试"),
    COMMON_ILLEGAL_PARAM(1010, "参数异常"),
    COMMON_THIRD_PARTY_TIMEOUT(1011, "第三方服务超时"),
    COMMON_ENUM_NOT_EXIST(1012,"枚举不存在"),
    
    ASSET_IN_CODE_ERROR(2001, "资产入库code异常! uuid : %s, bizNo : %s, code : %s"),
	GET_DEC_ATTRIBUTE_VALUE_ERROR(2002, "获取决策资产属性值异常, uuid : %s, keys : %s");
	
	

    public int code;
    public String text;
    public String frontEndToastTemplate;

    QGExceptionType(int code, String text) {
        this.code = code;
        this.text = text;
        this.frontEndToastTemplate = text;
    }

    QGExceptionType(int code, String text, String frontEndToastTemplate) {
        this.code = code;
        this.text = text;
        this.frontEndToastTemplate = frontEndToastTemplate;
    }

    public static QGExceptionType fromCode(int code) {
        for (QGExceptionType exceptionType : QGExceptionType.values()) {
            if (exceptionType.code == code) {
                return exceptionType;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "error_code: " + code + ", text: " + text + ", frontEndToastTemplate: " + frontEndToastTemplate;
    }
}
