package com.quantgroup.asset.distribution.util;

import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.Years;

import java.util.Calendar;
import java.util.Date;

/**
 * @author shihuajun
 * @date 2021/8/31 12:33
 * @ describing
 */
public class IdCardUtil {
    /**
     * 从身份证号中获取生日 xxxx-xx-xx
     *
     * @param idcard
     * @return
     */
    public static String getBirthday(String idcard) {
        if (StringUtils.isBlank(idcard)) {
            return null;
        }
        Date date = null;
        int len = StringUtils.trim(idcard).length();
        if (len == 15) {
            date = getBrithBy15IdCard(idcard);
        } else if (len == 18) {
            date = getBrithBy18IdCard(idcard);
        } else {
            return null;
        }
        return DateUtil.toString(date, DateUtil.DateTimeUtilFormat.yyyy_MM_dd);
    }

    /**
     * 根据身份证号获取年龄
     *
     * @param idcard
     * @return
     */
    public static int getAge(String idcard) {
        String birthday = getBirthday(idcard);
        return getAgeByBirthday(birthday);
    }

    /**
     * 根据生日获取周岁
     *
     * @param birthday yyyy-MM-dd
     * @return
     */
    public static int getAgeByBirthday(String birthday) {
        if (StringUtils.isEmpty(birthday)) {
            return -1;
        }
        return Years.yearsBetween(
                DateUtil.toDateTime(birthday, DateUtil.DateTimeUtilFormat.yyyy_MM_dd).toLocalDate(),
                new LocalDate()).getYears();
    }

    private static Date getBrithBy18IdCard(String idcard18) {
        try {
            Integer year = Integer.valueOf(idcard18.substring(6, 10));
            Integer month = Integer.valueOf(idcard18.substring(10, 12));
            Integer day = Integer.valueOf(idcard18.substring(12, 14));
            return constructDate(year, month, day);
        } catch (Exception e) {
            return null;
        }
    }

    private static Date getBrithBy15IdCard(String idCard15) {
        try {
            Integer year = Integer.valueOf(idCard15.substring(6, 8)) + 1900;
            Integer month = Integer.valueOf(idCard15.substring(8, 10));
            Integer day = Integer.valueOf(idCard15.substring(10, 12));
            return constructDate(year, month, day);
        } catch (Exception e) {
            return null;
        }
    }

    private static Date constructDate(Integer year, Integer month, Integer day) {
        Calendar c = Calendar.getInstance();
        c.set(Calendar.YEAR, year);
        c.set(Calendar.MONTH, month - 1);
        c.set(Calendar.DAY_OF_MONTH, day);
        c.set(Calendar.HOUR_OF_DAY, 0);
        c.set(Calendar.MINUTE, 0);
        c.set(Calendar.SECOND, 0);
        c.set(Calendar.MILLISECOND, 0);
        return c.getTime();
    }

    public static String getCityCodeByIdCard(String idcard) {
        int len = idcard.length();
        return len != 15 && len != 18 ? null : idcard.substring(0, 6);
    }

    public static void main(String[] args) {
        System.out.println(getCityCodeByIdCard("412822199407226911"));
    }
}
