package com.quantgroup.asset.distribution.service.product.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.quantgroup.asset.distribution.enums.ExecuteType;
import com.quantgroup.asset.distribution.model.form.AssetForm;
import com.quantgroup.asset.distribution.service.product.IFinanceProductHitLogService;
import com.quantgroup.asset.distribution.service.product.IFinanceProductService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : Hyuk
 * @description : FInanceProdcutServiceIMpl
 * @date : 2020/3/30 5:11 下午
 */
@Slf4j
@Service
public class FinanceProductServiceImpl implements IFinanceProductService {

    @Autowired
    private IFinanceProductHitLogService financeProductHitLogService;


    @Override
    public String createSingletonFinanceProduct(String amount, String term, String fundId, String fundProId) {
        JSONArray fundArray = createSingletonFundArr(fundId, fundProId);
        JSONArray financeProductArray = new JSONArray();
        JSONObject amountJSON = new JSONObject();
        financeProductArray.add(amountJSON);
        amountJSON.put("min", amount);
        amountJSON.put("max", amount);
        JSONArray termArray = new JSONArray();
        amountJSON.put("terms", termArray);
        JSONObject termJSON = new JSONObject();
        termArray.add(termJSON);
        try {
            // 不能是string，否则资方那边会报错
            termJSON.put("term", Integer.parseInt(term));
        } catch (Exception e) {
            termJSON.put("term", Double.parseDouble(term));
        }
        termJSON.put("fundInfo", fundArray);
        return JSON.toJSONString(financeProductArray);
    }

    @Override
    public AssetForm checkFundResult(AssetForm assetForm, String hitFinanceProduct, Long deadLine) {
        if (hitFinanceProduct == null) {
            if ("false".equals(assetForm.getAuditResult())) {
                // 把传过来的额度和期数处理为null
                assetForm.setAmount(null);
                assetForm.setTerm(null);
            }
            return assetForm;
        }

        // 金融产品集替换
        String oldFinanceProduct = assetForm.getFinanceProducts();
        assetForm.setFinanceProducts(hitFinanceProduct);

        // 审核结果替换
        String oldAuditResult = assetForm.getAuditResult();
        if ("false".equals(oldAuditResult)) {
            assetForm.setAuditResult("true");
        }

        // 截止时间替换
        if (deadLine != null) { assetForm.setDeadLine(String.valueOf(deadLine)); }

        // 保存日志
        financeProductHitLogService.saveLog(assetForm, oldFinanceProduct, hitFinanceProduct, oldAuditResult, assetForm.getAuditResult(), ExecuteType.ONLINE);
        log.info("资方命中后，审核最终结果, assetForm : {}", JSON.toJSONString(assetForm));
        return assetForm;
    }

    @Override
    public AssetForm checkFundResult(AssetForm assetForm, String hitFinanceProduct) {
        return checkFundResult(assetForm, hitFinanceProduct, null);
    }

    private JSONArray createSingletonFundArr(String fundId, String fundProductId) {
        JSONArray fundArray = new JSONArray();
        JSONObject fundInfoJSON = new JSONObject();
        fundInfoJSON.put("fundId", fundId);
        fundInfoJSON.put("fundProductId", fundProductId);
        fundInfoJSON.put("priority", 1);
        fundInfoJSON.put("feeType", 1);
        fundInfoJSON.put("rateType", 1);
        fundInfoJSON.put("rate", 0);
        fundArray.add(fundInfoJSON);
        return fundArray;
    }
}
