package com.quantgroup.asset.distribution.service.jpa.entity;

import javax.persistence.*;
import java.sql.Timestamp;
import java.util.Objects;

/**
 * @author shihuajun
 * @date 2021/9/7 15:57
 * @ describing
 */
@Entity
@Table(name = "fund_product", schema = "asset-distribution", catalog = "")
public class FundProductEntity {
    private long id;
    private long fundId;
    private long fundProId;
    private String fundName;
    private String fundType;
    private String orgType;
    private String businessType;
    private String systermType;
    private String basicRule;
    private int areaTerm;
    private int cardLimit;
    private String areaRule;
    private String ruleList;
    private Byte enable;
    private Timestamp createdAt;
    private Timestamp updatedAt;

    @Id
    @Column(name = "id", nullable = false)
    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Basic
    @Column(name = "fund_id", nullable = false)
    public long getFundId() {
        return fundId;
    }

    public void setFundId(long fundId) {
        this.fundId = fundId;
    }

    @Basic
    @Column(name = "fund_pro_id", nullable = false)
    public long getFundProId() {
        return fundProId;
    }

    public void setFundProId(long fundProId) {
        this.fundProId = fundProId;
    }

    @Basic
    @Column(name = "fund_name", nullable = false, length = 100)
    public String getFundName() {
        return fundName;
    }

    public void setFundName(String fundName) {
        this.fundName = fundName;
    }

    @Basic
    @Column(name = "fund_type", nullable = false, length = 20)
    public String getFundType() {
        return fundType;
    }

    public void setFundType(String fundType) {
        this.fundType = fundType;
    }

    @Basic
    @Column(name = "org_type", nullable = false, length = 20)
    public String getOrgType() {
        return orgType;
    }

    public void setOrgType(String orgType) {
        this.orgType = orgType;
    }

    @Basic
    @Column(name = "business_type", nullable = false, length = 20)
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    @Basic
    @Column(name = "systerm_type", nullable = false, length = 20)
    public String getSystermType() {
        return systermType;
    }

    public void setSystermType(String systermType) {
        this.systermType = systermType;
    }

    @Basic
    @Column(name = "basic_rule", nullable = false, length = 500)
    public String getBasicRule() {
        return basicRule;
    }

    public void setBasicRule(String basicRule) {
        this.basicRule = basicRule;
    }

    @Basic
    @Column(name = "area_term", nullable = false)
    public int getAreaTerm() {
        return areaTerm;
    }

    public void setAreaTerm(int areaTerm) {
        this.areaTerm = areaTerm;
    }

    @Basic
    @Column(name = "card_limit", nullable = false)
    public int getCardLimit() {
        return cardLimit;
    }

    public void setCardLimit(int cardLimit) {
        this.cardLimit = cardLimit;
    }

    @Basic
    @Column(name = "area_rule", nullable = false, length = 500)
    public String getAreaRule() {
        return areaRule;
    }

    public void setAreaRule(String areaRule) {
        this.areaRule = areaRule;
    }

    @Basic
    @Column(name = "rule_list", nullable = false, length = 500)
    public String getRuleList() {
        return ruleList;
    }

    public void setRuleList(String ruleList) {
        this.ruleList = ruleList;
    }

    @Basic
    @Column(name = "enable", nullable = true)
    public Byte getEnable() {
        return enable;
    }

    public void setEnable(Byte enable) {
        this.enable = enable;
    }

    @Basic
    @Column(name = "created_at", nullable = false)
    public Timestamp getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(Timestamp createdAt) {
        this.createdAt = createdAt;
    }

    @Basic
    @Column(name = "updated_at", nullable = false)
    public Timestamp getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(Timestamp updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        FundProductEntity that = (FundProductEntity) o;
        return id == that.id && fundId == that.fundId && fundProId == that.fundProId && areaTerm == that.areaTerm && cardLimit == that.cardLimit && Objects.equals(fundName, that.fundName) && Objects.equals(fundType, that.fundType) && Objects.equals(orgType, that.orgType) && Objects.equals(businessType, that.businessType) && Objects.equals(systermType, that.systermType) && Objects.equals(basicRule, that.basicRule) && Objects.equals(areaRule, that.areaRule) && Objects.equals(ruleList, that.ruleList) && Objects.equals(enable, that.enable) && Objects.equals(createdAt, that.createdAt) && Objects.equals(updatedAt, that.updatedAt);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, fundId, fundProId, fundName, fundType, orgType, businessType, systermType, basicRule, areaTerm, cardLimit, areaRule, ruleList, enable, createdAt, updatedAt);
    }
}
