package com.quantgroup.asset.distribution.util;

import lombok.Data;

import java.util.List;

/**
 *
 */
@Data
public class AllRecords<T> {

    //总页数
    private long totalPage;
    //总数量
    private long totalNumber;
    //索引
    private int pageIndex;
    //每页条数
    private long pageSize;
    //分页的列表数据
    private List<T> dataList;

    //计算总页数
    public void resetTotalNumber(long totalNumber) {
        if (totalNumber!=0){
            this.totalNumber = totalNumber;
            this.totalPage = totalNumber / this.pageSize;
            if(totalNumber % this.pageSize != 0L) {
                ++this.totalPage;
            }
        }

    }

}
