package com.quantgroup.asset.distribution.service.jpa.repository;

import com.quantgroup.asset.distribution.service.jpa.entity.ChannelRuleEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;

import java.util.List;

public interface IChannelRuleRepository extends JpaRepository<ChannelRuleEntity, Long>, QueryDslPredicateExecutor<ChannelRuleEntity> {
    ChannelRuleEntity getByFundProductIdEquals(long fundProductId);

    List<ChannelRuleEntity> getByChannelId(long channelId);

    List<ChannelRuleEntity> getAllByEnableEquals(Boolean enable);

    List<ChannelRuleEntity> getAllByChannelIdEqualsAndEnableEquals(Long channelId,Boolean enable);

    List<ChannelRuleEntity> getAllByIdIn(List<Long> ids);

    void deleteAllByChannelIdEqualsAndEnableEquals(Long channelId,Boolean enable);

}
