package com.quantgroup.asset.distribution.service.newrule.pojo.enums;

import lombok.Getter;

/**
 * @author shihuajun
 * @date 2021/9/7 14:23
 * @ describing
 */
@Getter
public enum IdCardExpireEnum {
    CURRENT(0,"范围当前有效"),
    EXPIRE_BIG_ONE(1,"有效期大于1年"),
    EXPIRE_BIG_LOAN(2,"有效期大于借款期限");

    private final Integer code;
    private final String desc;

    IdCardExpireEnum(Integer code,String desc){
        this.code = code;
        this.desc = desc;
    }

    public static IdCardExpireEnum parse(int code){
        for (IdCardExpireEnum ae : IdCardExpireEnum.values()) {
            if (code == ae.getCode()){
                return ae;
            }
        }
        throw new RuntimeException("解析IdCardExpireEnum出问题了，没有对应的枚举类型");
    }
}
