package com.quantgroup.asset.distribution.service.jpa.repository;

import com.quantgroup.asset.distribution.service.jpa.entity.ChannelRuleEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;

import java.util.List;

public interface IChannelRuleRepository extends JpaRepository<ChannelRuleEntity, Long>, QueryDslPredicateExecutor<ChannelRuleEntity> {
    ChannelRuleEntity getByFundProductIdEquals(long fundProductId);

    List<ChannelRuleEntity> getByChannelId(long channelId);

    List<ChannelRuleEntity> getAllByEnableEquals(Byte enable);

    List<ChannelRuleEntity> getAllByChannelIdEqualsAndEnableEquals(Long channelId,Byte enable);

    List<ChannelRuleEntity> getAllByIdIn(List<Long> ids);

    Boolean deleteAllByChannelIdEqualsAndEnableEquals(Long channelId,Byte enable);

}
