package com.quantgroup.asset.distribution.service.asset.impl;

import com.alibaba.fastjson.JSON;
import com.quantgroup.asset.distribution.constant.BizAssetOrderStatus;
import com.quantgroup.asset.distribution.model.form.AssetForm;
import com.quantgroup.asset.distribution.service.alarm.IAlarmService;
import com.quantgroup.asset.distribution.service.asset.IBizAssetOrderService;
import com.quantgroup.asset.distribution.service.jpa.entity.BizAssetOrder;
import com.quantgroup.asset.distribution.service.jpa.repository.IBizAssetOrderRepository;
import com.quantgroup.asset.distribution.service.redis.IRedisService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @author : Hyuk
 * @description : BizAssetOrderServiceImpl
 * @date : 2020/6/9 2:55 下午
 */
@Slf4j
@Service
public class BizAssetOrderServiceImpl implements IBizAssetOrderService {

    @Autowired
    private IBizAssetOrderRepository bizAssetOrderRepository;
    @Autowired
    private IRedisService<BizAssetOrder> redisService;
    @Autowired
    private IAlarmService alarmService;

    private static final String BIZ_ASSET_ORDER_KEY_PREFIX = "ASSET_DISTRIBUTION:BIZ_ASSET_ORDER:KASMN9:";

    @Override
    public void saveAssetOrder(AssetForm assetForm) {
        BizAssetOrder bizAssetOrder = new BizAssetOrder();
        bizAssetOrder.setBizChannel(assetForm.getBizChannel());
        bizAssetOrder.setBizNo(assetForm.getBizNo());
        bizAssetOrder.setBizType(Integer.parseInt(assetForm.getBizType()));
        bizAssetOrder.setUuid(assetForm.getUuid());
        bizAssetOrder.setContext(JSON.toJSONString(assetForm));
        bizAssetOrder.setStatus(BizAssetOrderStatus.DISTRIBUTING);
        bizAssetOrder.setEnable(true);

        BizAssetOrder dbBizAssetOrder = bizAssetOrderRepository.save(bizAssetOrder);
        String redisKey = getBizAssetOrderKey(assetForm.getUuid(), assetForm.getBizNo(), assetForm.getBizType());
        redisService.setEntityEx(redisKey, dbBizAssetOrder, 30, TimeUnit.MINUTES);
    }

    @Override
    public void finishAssetOrder(AssetForm assetForm) {
        BizAssetOrder bizAssetOrder = redisService.getEntity(getBizAssetOrderKey(assetForm.getUuid(),
                assetForm.getBizNo(), assetForm.getBizType()));

        if (bizAssetOrder == null) {
            List<BizAssetOrder> bizAssetOrders = bizAssetOrderRepository
                    .findByUuidAndBizNoAndBizTypeAndStatusAndEnableIsTrue(assetForm.getUuid(), assetForm.getBizNo(),
                            Integer.parseInt(assetForm.getBizType()), BizAssetOrderStatus.DISTRIBUTING);
            if (CollectionUtils.isEmpty(bizAssetOrders)) {
                log.info("资产分发订单缺失, uuid : {}, bizNo : {}, bizType : {}", assetForm.getUuid(), assetForm.getBizNo(), assetForm.getBizType());
                alarmService.dingtalkAlarm("Warn", "未找到资产分发中的订单", "uuid : " + assetForm.getUuid() +
                        " , bizNo : " + assetForm.getBizNo() + " , bizType : " + assetForm.getBizType());
                return;
            }

            bizAssetOrder = bizAssetOrders.get(0);
        }

        bizAssetOrder.setStatus(BizAssetOrderStatus.DISTRIBUTE_FINISH);
        bizAssetOrderRepository.save(bizAssetOrder);
    }

    /**
     * 获取资产订单缓存redisKey
     * @param uuid
     * @param bizNo
     * @param bizType
     * @return
     */
    private String getBizAssetOrderKey(String uuid, String bizNo, String bizType) {
        StringBuilder sb = new StringBuilder(BIZ_ASSET_ORDER_KEY_PREFIX);
        sb.append(uuid).append(":").append(bizNo).append(":").append(bizType);
        return sb.toString();
    }
}
