package com.quantgroup.asset.distribution.model.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import lombok.Data;

@Data
public class DistributeRecord implements Serializable{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Map<String, Object> data;
	
	private List<Record> records;
	
	public DistributeRecord(Map<String, Object> data) {
		this.data = data;
		records = new ArrayList<>();
	}
	
	public void addRecords(Long id, String expression, Integer type, String name, Boolean valid) {
		Record record = new Record();
		record.setId(id);
		record.setExpression(expression);
		record.setType(type);
		record.setName(name);
		record.setValid(valid);
		if (records == null) {
			records = new ArrayList<>();
		}
		records.add(record);
	}
	
	public void clearRecords() {
		records.clear();
	}
}
