package com.quantgroup.asset.distribution.niwodai;

import cn.quantgroup.motan.bean.UserInfo;
import cn.quantgroup.motan.vo.UserSysResult;
import cn.quantgroup.user.IUserSdkService;
import cn.quantgroup.user.UserSdkServiceFactory;
import com.alibaba.fastjson.JSON;
import com.quantgroup.asset.distribution.AssetDistributionBootstrap;
import com.quantgroup.asset.distribution.service.niwodai.INiwodaiAssetService;
import com.quantgroup.asset.distribution.service.niwodai.INiwodaiService;
import com.quantgroup.asset.distribution.service.niwodai.vo.*;
import com.quantgroup.asset.distribution.util.GZIPUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.PostConstruct;
import java.math.BigDecimal;
import java.util.Map;

@RunWith(SpringRunner.class)
@SpringBootTest(classes = AssetDistributionBootstrap.class)
public class NiwodaiTest {
	
	@Autowired
	private INiwodaiService niwodaiService;
	@Autowired
	private INiwodaiAssetService niwodaiAssetService;
	@Autowired
	@Qualifier("httpClient")
	private CloseableHttpClient httpClient;
	@Value("${user.sdk.url}")
	private String userSysUrl;
	private IUserSdkService userSdkService;
	@PostConstruct
	private void init() {
		userSdkService = UserSdkServiceFactory.generateSDKService(userSysUrl, httpClient);
	}
	
	@Test
	public void testCheck() throws Exception {
		NiwodaiDataImportCheckResponseVO responseVO = niwodaiAssetService.dataCheck("9f7f857c-10c3-42aa-8fc5-31c37e988b3e");
		System.out.println(JSON.toJSONString(responseVO));
	}

	@Test
	public void testUser(){
		Map<String,Object> userInfoByUuid = niwodaiAssetService.queryUserBasic2Info("ae7d04bf-1c5a-475b-98d2-b193be88cf2f","13780000000",true);
		System.out.println(JSON.toJSONString(userInfoByUuid));
	}

	@Test
	public void userBase(){
		System.out.println(JSON.toJSONString(userSdkService.findUserInfoByUuid("097aae98-5da4-428b-aa40-93530b6b5f4b")));
	}



	@Test
	public void testIncoming() {
		NiwodaiIncomingResponseVO vo = niwodaiAssetService.incoming("ae7d04bf-1c5a-475b-98d2-b193be88cf2f","1028791648161","10000",12);
		System.out.println(JSON.toJSONString(vo));
	}

}
