package com.quantgroup.asset.distribution.service.distribute;

import java.util.List;

import com.quantgroup.asset.distribution.model.entity.DistributeRecord;
import com.quantgroup.asset.distribution.service.jpa.entity.Asset;
import com.quantgroup.asset.distribution.service.jpa.entity.AssetDistributeRecord;

/**
 * 资产分发记录Service
 * @author liwenbin
 *
 */
public interface IAssetDistributeRecordService {

	/**
	 * 保存记录
	 * @param asset
	 * @param distributeRecord
	 * @param distributeStatus
	 */
	public void saveDistributeRecord(Asset asset, DistributeRecord distributeRecord, Boolean distributeStatus, int ruleType);
	
	/**
	 * 获取资产分发记录
	 * @param assetNo
	 * @return
	 */
	public List<AssetDistributeRecord> getDistributeRecord(String assetNo);
}
