package com.quantgroup.asset.distribution.service.rule.impl;

import java.math.BigDecimal;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.quantgroup.asset.distribution.exception.QGException;
import com.quantgroup.asset.distribution.exception.QGExceptionType;
import com.quantgroup.asset.distribution.exception.QGPreconditions;
import com.quantgroup.asset.distribution.service.rule.IRuleService;
import com.quantgroup.asset.distribution.util.calc.Expression;
import com.quantgroup.asset.distribution.util.calc.Expression.ExpressionException;

import lombok.extern.slf4j.Slf4j;

/**
 * 规则判断
 * @author liwenbin
 *
 */
@Slf4j
@Service
public class RuleServiceImpl implements IRuleService{

	@Override
	public boolean valid(String expression, Map<String, Object> data) {
		try {
			// 如果el表达式为空，返回true
			if (StringUtils.isEmpty(expression)) { return true; }
			Expression ex = new Expression(expression);
			for (Map.Entry<String, Object> entry : data.entrySet()) {
				ex.with(entry.getKey(), String.valueOf(entry.getValue()));
			}
			BigDecimal res = ex.eval();
			QGPreconditions.checkArgument(res.compareTo(BigDecimal.ZERO) == 0 || res.compareTo(BigDecimal.ONE) == 0, QGExceptionType.RULE_CALC_UNKNOW_RESULT, expression);
			return res.compareTo(BigDecimal.ONE) == 0;
		} catch (ExpressionException expressionException) {
			log.error("规则判断出现错误, expression : {}, data : {}", expression, JSON.toJSONString(data), expressionException);
			throw new QGException(QGExceptionType.RULE_CALC_ERROR, expression);
		} catch (Exception e) {
			log.error("规则判断出现未知异常, expression : {}, data : {}", expression, JSON.toJSONString(data), e);
			throw new QGException(QGExceptionType.RULE_CALC_UNKNOW_ERROR, expression);
		}
	}

}
