package com.quantgroup.asset.distribution.service.niwodai.vo;

import lombok.Data;

import java.math.BigDecimal;

public class NiwodaiCostant {
    @Data
    public static class UserInfo {
        /**
         * 姓名 必填
         */
        private String realName;
        /**
         * 用户ID 非必填
         */
        private String externalUserId;
        /**
         * 身份证号（遇到x统一转化为大写） 必填
         */
        private String idcardNumber;
        /**
         * 手机号 必填
         */
        private String phone;
        /**
         * 婚姻状况，参见附录 必填
         */
        private String maritalStatus;
        /**
         * 子女数量，参见附录 非必填
         */
        private Integer childrenNum;
        /**
         * 性别,参见附录 必填
         */
        private String gender;
        /**
         * 学历，参见附录  必填
         */
        private String education;
        /**
         * 常用邮箱  非必填
         */
        private String email;
        /**
         * 职业，参见附录 必填
         */
        private String occupation;
        /**
         * 身份证户籍地址 非必填
         */
        private String idcardAddress;
        /**
         * 发证机关 非必填
         */
        private String idcardAuthority;
        /**
         * 证件有效期(yyyyMMdd-yyyyMMdd) 必填
         */
        private String idcardValidity;
        /**
         * 民族(如：汉) 非必填
         */
        private String nation;
        /**
         * 身份证正面图片 必填
         */
        private String idcardFront;
        /**
         * 身份证反面图片 必填
         */
        private String idcardBack;
        /**
         * 活体照片 必填
         */
        private String bioPhoto;
        /**
         * 手持身份证照片 非必填
         */
        private String handIdPhoto;
        /**
         * 照片类型:URL, BASE64 必填
         */
        private String imageType;
        /**
         * 所在省份 必填
         */
        private String province;
        /**
         * 所在城市 必填
         */
        private String city;
        /**
         * 所在区县 非必填
         */
        private String district;
        /**
         * 详细居住地址 必填
         */
        private String address;
        /**
         * 所属行业，参见附录 必填
         */
        private String industry;
        /**
         * 月收入,参见附录 必填
         */
        private String income;
        /**
         * 收入来源，参见附录 非必填
         */
        private String incomeType;
        /**
         * 负债情况,参见附录 必填
         */
        private String debt;
        /**
         * 借记卡卡号 非必填
         */
        private String debitCardNumber;
        /**
         * 信用卡卡号 非必填
         */
        private String creditCardNumber;
    }

    @Data
    public static class LoanInfo{
        /**
         * 贷款金额(如：5000.00)   必填
         */
        private BigDecimal amount;
        /**
         * 贷款期数  必填
         */
        private Integer term;
        /**
         * 贷款用途   必填
         */
        private String purpose;
    }
    @Data
    public static class CompnayInfo{
        /**
         * 工作单位全称  必填
         */
        private String name;
        /**
         * 公司所在省份 必填
         */
        private String province;
        /**
         * 公司所在城市 必填
         */
        private String city;
        /**
         * 公司所在区县 非必填
         */
        private String district;
        /**
         * 公司电话 非必填
         */
        private String phone;
        /**
         * 公司详细地址 必填
         */
        private String address;
        /**
         * 当前公司入职日期，格式：2017-07-01   非必填
         */
        private String hireDate;
        /**
         * 公司类型，参见附录 非必填
         */
        private String type;
        /**
         * 职级，参见附录 非必填
         */
        private String rank;
    }
    @Data
    public static class Contacts{
        /**
         * 第一联系人姓名  必填
         */
        private String nameA;
        /**
         * 第一联系人电话  必填
         */
        private String phoneA;
        /**
         * 第一联系人关系  必填
         */
        private String relationshipA;
        /**
         * 第二联系人姓名  必填
         */
        private String nameB;
        /**
         * 第二联系人电话  必填
         */
        private String phoneB;
        /**
         * 第二联系人关系  必填
         */
        private String relationshipB;
    }
    @Data
    public static class MnoData{
        /**
         * 运营商分析报告，JSON序列化后的字符串(需要GZIP压缩)
         */
        private String report;
        /**
         * 运营商详单，JSON序列化后的字符串(需要GZIP压缩)
         */
        private String details;
    }
    @Data
    public static class CreditRefData{
        /**
         * 客户授权人行征信查询时间，精确到秒  非必填
         */
        private String authTime;
    }
    public enum Gender{
        /**
         * 男
         */
        MALE,
        /**
         * 女
         */
        FEMALE;
    }

    public enum MaritalStatus{
        /**
         * 未婚
         */
        UNMARRIED,
        /**
         * 已婚
         */
        MARRIED,
        /**
         * 离异
         */
        DIVORCE,
        /**
         * 丧偶
         */
        WIDOWEDSPOUSE;
    }

    public enum ChildrenNum{
        /**
         * 无子女
         */
        NONE,
        /**
         * 一个子女
         */
        ONE,
        /**
         * 两个子女
         */
        TWO,
        /**
         * 三个以上
         */
        ABOVE_THREE;
    }

    public enum  EducationalBackground{
        /**
         * 初中及以下
         */
        JUNIOR_SCHOOL_AND_BELOW,
        /**
         * 高中或中专
         */
        HIGH_SCHOOL,
        /**
         * 大学专科
         */
        ACADEMY,
        /**
         * 大学本科
         */
        UNIVERSITY,
        /**
         * 研究生或以上
         */
        POSTGRADUATE_AND_ABOVE;
    }

    public enum Occupation{
        /**
         * 私营业主
         */
        PRIVATE_OWNERS,
        /**
         * 上班族
         */
        WORKER,
        /**
         * 个体工商户
         */
        BUSINESSMEN,
        /**
         * 自由职业者
         */
        PROFESSIONAL,
        /**
         * 退休/待业/无业
         */
        BE_UNEMPLOYED,
        /**
         * 在校学生
         */
        STUDENT,
        /**
         * 农民
         */
        FARMER;
    }
    /**
     * 所属行业
     */
    public enum Industry{
        /**
        *农业/林业/畜牧业/渔业
        **/
        AGRICULTURE,
        /**
         *采矿业
         **/
        MINING_INDUSTRY,
        /**
         *制造业
         **/
        MANUFACTURING_INDUSTRY,
        /**
         *电力/热力/燃气/水生产/供应业
         **/
        SUPPLY_INDUSTRY,
        /**
         *建筑业
         **/
        CONSTRUCTION_BUSINESS,
        /**
         *批发/零售业
         **/
        RETAIL,
        /**
         *交通运输/仓储业/邮政业
         **/
        TRANSPORTATION,
        /**
         *住宿/餐饮业
         **/
        RESTAURANT,
        /**
         *信息传输/软件/信息技术服务业
         **/
        INFORMATION_TECHNOLOGY_SERVICES,
        /**
         *金融业
         **/
        FINANCE,
        /**
         *房地产业
         **/
        ESTATE,
        /**
         *租赁/商务服务业
         **/
        BUSINESS_SERVICES,
        /**
         *科学研究/技术服务业
         **/
        TECHNOLOGICAL_SERVICES,
        /**
         *水利/环境/公共设施管理业
         **/
        PUBLIC_FACILITY_MANAGEMENT,
        /**
         *居民服务/修理/其他服务业
         **/
        RESIDENT_SERVICE,
        /**
         *教育
         **/
        EDUCATION,
        /**
         *卫生/社会工作
         **/
        SOCIAL_WORK,
        /**
         *文化/体育/娱乐业
         **/
        ENTERTAINMENT,
        /**
         *公共管理/社会保障/社会组织/国际组织
         **/
        PUBLIC_ADMINISTRATION,
        /**
         *未知
         **/
        UNKNOWN;
    }
    /**
     * 月收入
     */
    public enum Income{
        /**
         * 无固定收入
         */
        ZERO,
        /**
         * 0-3000元
         */
        ONE,
        /**
         * 3000-6000元
         */
        TWO,
        /**
         * 6000-10000元
         */
        THREE,
        /**
         * 10000-15000元
         */
        FOUR,
        /**
         * 	15000-20000元
         */
        FIVE,
        /**
         * 20000元及以上
         */
        SIX;
    }
    /**
     * 收入来源
     */
    public enum IncomeType{
        /**
         * 工资奖金
         */
        SALARY,
        /**
         * 经营收入
         */
        OPERATING_INCOME,
        /**
         * 投资理财
         */
        INVESTMENT,
        /**
         * 房租收入
         */
        HOUSE_RENT,
        /**
         * 其他
         */
        OTHER;
    }

    /**
     * 负债情况
     */
    public enum Debt{
        /**
         * 无负债
         */
        ZERO,
        /**
         * 0-3000元
         */
        ONE,
        /**
         * 3000-6000元
         */
        TWO,
        /**
         * 6000-10000元
         */
        THREE,
        /**
         * 10000-15000元
         */
        FOUR,
        /**
         * 15000-20000元
         */
        FIVE,
        /**
         * 20000元及以上
         */
        SIX;
    }
    /**
     * 贷款用途
     */
    public enum Purpose{
        /**
         * 个人日常消费
         */
        CONSUMPTION,
        /**
         * 房屋装修
         */
        RENOVATION,
        /**
         * 电子数码
         */
        ELECTRONIC_PRODUCT,
        /**
         * 旅游
         */
        TOURISM;
    }

    /**
     * 联系人关系
     */
    public enum Relationship{
        /**
         * 父亲
         */
        FATHER,
        /**
         * 母亲
         */
        MOTHER,
        /**
         * 儿子
         */
        SON,
        /**
         * 女儿
         */
        DAUGHTER,
        /**
         * 	哥哥
         */
        BROTHER,
        /**
         * 弟弟
         */
        YOUNGER_BROTHER,
        /**
         * 姐姐
         */
        SISTER,
        /**
         * 妹妹
         */
        YOUNGER_SISTER,
        /**
         * 配偶
         */
        SPOUSE,
        /**
         * 同事
         */
        COLLEAGUE,
        /**
         * 朋友
         */
        FRIEND,
        /**
         * 同学
         */
        CLASSMATE,
        /**
         * 其他
         */
        OTHER;
    }
    /**
     * 公司类型
     */
    public enum Type{
        /**
         * 政府或企事业单位
         */
        GOVERNMENT_OR_INSTITUTION,
        /**
         * 国企央企
         */
        SOE,
        /**
         * 外资企业
         */
        FOREIGN_ENTERPRISE,
        /**
         * 上市公司
         */
        LISTED_COMPANY,
        /**
         * 普通民营企业
         */
        PRIVATE_ENTERPRISE,
        /**
         * 	个体工商户
         */
        INDIVIDUAL_BUSINESS,
        /**
         * 其他
         */
        OTHER;
    }

    /**
     * 职级
     */
    public enum Rank{
        /**
         * 高级领导
         */
        DIRECTOR,
        /**
         * 中级领导
         */
        MANAGER,
        /**
         * 一般员工
         */
        EMPLOYEES,
        /**
         * 其他
         */
        OTHER,
        /**
         * 未知
         */
        UNKNOWN;
    }

}
