package com.quantgroup.asset.distribution.service.jpa.entity;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Created by renfeng on 2019/7/17.
 */
@Entity
@Table(name="aid_loan_fund_route_record")
@Data
public class AidLoanFundRouteRecord implements Serializable{

    private static final long serialVersionUID = -1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name="asset_no")
    private String assetNo;

    @Column(name="fund_no")
    private String fundNo;

    @Column(name="uuid")
    private String uuid;

    @Column(name="user_loan_type")
    private Integer userLoanType;

    @Column(name="biz_channel")
    private String bizChannel;

    @Column(name="finance_product_type")
    private Integer financeProductType;

    @Column(name="biz_no")
    private String bizNo;

    @Column(name="aid_fund_route_travel")
    private String aidFundRouteTravel;

    @Column(name="fund_id")
    private String fundId;

    @Column(name="aid_fund_route_no")
    private String aidFundRouteNo;

    @Column(name="aid_fund_route_status")
    private Integer aidFundRouteStatus;

    @Column(name = "enable")
    private Boolean enable;

    @Column(name = "created_at")
    private Timestamp createdAt;

    @Column(name = "updated_at")
    private Timestamp updatedAt;


    @PrePersist
    public void prePersist() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        createdAt = timestamp;
        updatedAt = timestamp;
    }

    @PreUpdate
    public void preUpdate() {
        updatedAt = new Timestamp(System.currentTimeMillis());
    }
}
