package com.quantgroup.asset.distribution.service.niwodai.impl;

import cn.quantgroup.motan.bean.UserInfo;
import cn.quantgroup.motan.vo.UserSysResult;
import cn.quantgroup.user.IUserSdkService;
import cn.quantgroup.user.UserSdkServiceFactory;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.lkb.data.hbase.dataservice.verify.OCRIdCardDataService;
import com.lkb.data.hbase.row.verify.OCRIdCardRow;
import com.quantgroup.asset.distribution.exception.QGException;
import com.quantgroup.asset.distribution.exception.QGExceptionType;
import com.quantgroup.asset.distribution.service.httpclient.IHttpService;
import com.quantgroup.asset.distribution.service.niwodai.INiwodaiAssetService;
import com.quantgroup.asset.distribution.service.niwodai.INiwodaiService;
import com.quantgroup.asset.distribution.service.niwodai.vo.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class NiwodaiAssetServiceImpl implements INiwodaiAssetService {

    @Autowired
    IHttpService iHttpService;
    @Autowired
    @Qualifier("httpClient")
    private CloseableHttpClient httpClient;
    @Autowired
    private INiwodaiService niwodaiService;
    @Value("${user.sdk.url}")
    private String userSysUrl;
    private IUserSdkService userSdkService;

   private static Gson GSON = new Gson();

    private static String[] companyNames = new String[]{"外企人力资源公司","中智人力资源公司","新绿人力资源公司","东浩人力资源公司"};

    @PostConstruct
    private void init() {
        userSdkService = UserSdkServiceFactory.generateSDKService(userSysUrl, httpClient);
    }

    @Override
    public NiwodaiIncomingResultResponseVO incomingResult(String orderId){
        NiwodaiIncomingResultRequestVO vo = new NiwodaiIncomingResultRequestVO();
        vo.setOrderId(orderId);
        return niwodaiService.incoingResult(vo);
    }

    @Override
    public NiwodaiDataImportCheckResponseVO dataCheck(String uuid){
        NiwodaiDataImportCheckRequestVO requestVO = new NiwodaiDataImportCheckRequestVO();
        requestVO.setExternalUserId(uuid);
        UserSysResult<UserInfo> userInfoByUuid = userSdkService.findUserInfoByUuid(uuid);
        if (!userInfoByUuid.isSuccess()){
            log.error("准入检查获取用户中心信息失败 uuid : {}",uuid);
            throw new QGException("获取用户中心信息失败", QGExceptionType.COMMON_ILLEGAL_PARAM);
        }
        requestVO.setPhone(userInfoByUuid.getData().getPhoneNo());
        List<OCRIdCardRow> list = OCRIdCardDataService.get(uuid);
        if (CollectionUtils.isEmpty(list)) {
            log.error("准入检查获取用户OCR信息失败 uuid : {}",uuid);
            throw new QGException("没有相关用户信息", QGExceptionType.COMMON_ILLEGAL_PARAM);
        }
        OCRIdCardRow ocrIdCardRow = list.get(0);
        IdCardA idCardFront = JSON.parseObject(ocrIdCardRow.getIdCardContentA(), IdCardA.class);
        requestVO.setIdcardNumber(idCardFront.getCitizen_id());
        requestVO.setRealName(idCardFront.getName());
        return niwodaiService.dataImportCheck(requestVO);
    }


    @Override
    public NiwodaiIncomingResponseVO incoming(String uuid, String orderId, String amount, Integer term) {
        List<OCRIdCardRow> list = OCRIdCardDataService.get(uuid);
        if (CollectionUtils.isEmpty(list)) {
            log.error("进件申请获取用户OCR信息失败 uuid : {}",uuid);
            throw new QGException("没有相关用户信息", QGExceptionType.COMMON_ILLEGAL_PARAM);
        }
        OCRIdCardRow ocrIdCardRow = list.get(0);
        UserSysResult<UserInfo> userInfoByUuid = userSdkService.findUserInfoByUuid(uuid);
        if (!userInfoByUuid.isSuccess()){
            log.error("进件申请获取用户中心信息失败 uuid : {}",uuid);
            throw new QGException("获取用户中心信息失败", QGExceptionType.COMMON_ILLEGAL_PARAM);
        }
        IdCardA idCardFront = JSON.parseObject(ocrIdCardRow.getIdCardContentA(), IdCardA.class);
        IdCardB idCardBack = JSON.parseObject(ocrIdCardRow.getIdCardContentB(), IdCardB.class);
        Map<String,Object> infoMap = queryUserBasic2Info(uuid,userInfoByUuid.getData().getPhoneNo(),true);
        NiwodaiIncomingRequestVO vo = new NiwodaiIncomingRequestVO();
        vo.setOrderId(orderId);
        NiwodaiCostant.UserInfo userInfo = new NiwodaiCostant.UserInfo();
        userInfo.setRealName(idCardFront.getName());
        userInfo.setIdcardNumber(idCardFront.getCitizen_id());
        userInfo.setPhone(userInfoByUuid.getData().getPhoneNo());
        userInfo.setMaritalStatus(conversMarryStatus((String) infoMap.get("marryStatus")).name());
        userInfo.setGender("男".equals(idCardFront.getGender()) ? NiwodaiCostant.Gender.MALE.name() : NiwodaiCostant.Gender.FEMALE.name());
        userInfo.setEducation(conversEducation((String) infoMap.get("education")).name());
        userInfo.setOccupation(conversOccupation((String) infoMap.get("vocation")).name());
        userInfo.setIdcardValidity(idCardBack.getValid_date_begin() + "-" + idCardBack.getValid_date_end());
        userInfo.setIdcardFront(ocrIdCardRow.getIdCardBaseContentA());
        userInfo.setIdcardBack(ocrIdCardRow.getIdCardBaseContentB());
        userInfo.setBioPhoto(ocrIdCardRow.getLivePhotoContent());
        userInfo.setImageType("BASE64");
        userInfo.setProvince((String) infoMap.get("province"));
        userInfo.setCity((String) infoMap.get("city"));
        userInfo.setDistrict((String) infoMap.get("district"));
        userInfo.setAddress(idCardFront.getAddress());
        userInfo.setIndustry(random(NiwodaiCostant.Industry.values()).name());
        userInfo.setIncome(conversIncome((String) infoMap.get("salary")).name());
        userInfo.setIncomeType(random(NiwodaiCostant.IncomeType.values()).name());
        userInfo.setDebt(NiwodaiCostant.Debt.ZERO.name());
        vo.setUserInfo(userInfo);
        NiwodaiCostant.LoanInfo loanInfo = new NiwodaiCostant.LoanInfo();
        loanInfo.setAmount(new BigDecimal(amount));
        loanInfo.setTerm(term);
        loanInfo.setPurpose(random(NiwodaiCostant.Purpose.values()).name());
        vo.setLoanInfo(loanInfo);
        NiwodaiCostant.Contacts contacts = new NiwodaiCostant.Contacts();
        contacts.setNameA((String) infoMap.get("firstName"));
        contacts.setPhoneA((String) infoMap.get("firstMobile"));
        contacts.setRelationshipA(conversRelationship((String)infoMap.get("firstRelation")).name());
        contacts.setNameB((String) infoMap.get("secondName"));
        contacts.setPhoneB((String) infoMap.get("secondMobile"));
        contacts.setRelationshipB(conversRelationship((String)infoMap.get("secondRelation")).name());
        vo.setContacts(contacts);
        NiwodaiCostant.CompnayInfo compnayInfo = new NiwodaiCostant.CompnayInfo();
        compnayInfo.setName(randomCompanyName());
        compnayInfo.setAddress(userInfo.getProvince()+userInfo.getCity()+compnayInfo.getName());
        compnayInfo.setCity(userInfo.getCity());
        compnayInfo.setProvince(userInfo.getProvince());
        vo.setCompanyInfo(compnayInfo);
        vo.setMnoData(new NiwodaiCostant.MnoData());
        return niwodaiService.incoming(vo);
    }


    private static String randomCompanyName(){
        int index = (int) (Math.random() * companyNames.length);
        return companyNames[index];
    }

    private static <T> T random(T[] objects){
        int index = (int) (Math.random() * objects.length);
        return objects[index];
    }

    @Override
    public Map<String,Object> queryUserBasic2Info(String userId, String phoneNo, boolean isQuery) {
        String url = userSysUrl+"/innerapi/user-association/search/userId?phoneNo="+phoneNo;
        Map<String,Object> mapResult = new HashMap<>();
        try{
            String result = iHttpService.get(url);
            JSONObject resultJson = JSON.parseObject(result);
            if(queryIsSuccess(resultJson)){
                mapResult.put("checkResult", true);
                BasicInfo2Detail basicInfo2Detail = GSON.fromJson(resultJson.getString("data"), new TypeToken<BasicInfo2Detail>(){}.getType());
                Map<String,Object> convertMap = new HashMap<>();
                check(basicInfo2Detail, mapResult, userId, convertMap);
                if(!isQuery){
                    mapResult.put("info", "");
                }else{
                    mapResult.put("info", convertMap);
                }
                mapResult.put("name", basicInfo2Detail.getName());
            }else{
                mapResult.put("checkResult", false);
            }
        }catch(Exception e){
            mapResult.put("checkResult", false);
            log.error("查询用户中心数据发生异常, userId: {} ", userId, e);
        }
        if (null == mapResult.get("info")){
            return new HashMap<>();
        }else {
            return (Map<String, Object>) mapResult.get("info");
        }
    }

    public static void check(BasicInfo2Detail basicInfo2Detail, Map<String,Object> map, String userId, Map<String,Object> convertMap){
        valuesChecker(basicInfo2Detail, map, userId);
        String vocation = basicInfo2Detail.getOccupationEnum();
        if(StringUtils.isNotEmpty(vocation)){
            convertMap.put("vocation", basicInfo2Detail.getOccupationEnum());
        }
        String salary = basicInfo2Detail.getIncomeRangeEnum();
        if(StringUtils.isNotEmpty(salary)){
            convertMap.put("salary", basicInfo2Detail.getIncomeRangeEnum());
        }
        String education = basicInfo2Detail.getEducationEnum();
        if(StringUtils.isNotEmpty(education)){
            convertMap.put("education", basicInfo2Detail.getEducationEnum());
        }
        String email = basicInfo2Detail.getEmail();
        if(StringUtils.isNotEmpty(email)){
            convertMap.put("email", basicInfo2Detail.getEmail());
        }
        String marryStatus = basicInfo2Detail.getMarryStatus();
        if (StringUtils.isNotEmpty(marryStatus)){
            convertMap.put("marryStatus",basicInfo2Detail.getMarryStatus());
        }
        List<Contacts> contacts = basicInfo2Detail.getContactList();
        List<Address> addresses = basicInfo2Detail.getAddressList();
        if(contacts!=null && contacts.size()>0){
            for(int i=0;i<contacts.size();i++){
                Contacts contacts1 = contacts.get(i);
                if(i==0){
                    String firstName = contacts1.getName();
                    if(StringUtils.isNotEmpty(firstName)){
                        convertMap.put("firstName", contacts1.getName());
                    }
                    String firstMobile = contacts1.getPhoneNo();
                    if(StringUtils.isNotEmpty(firstMobile)){
                        convertMap.put("firstMobile", contacts1.getPhoneNo());
                    }
                    String relation = contacts1.getRelationName();
                    if(StringUtils.isNotEmpty(relation)){
                        convertMap.put("firstRelation", contacts1.getRelationName());
                    }
                }else if(i==1){
                    String secondName = contacts1.getName();
                    if(StringUtils.isNotEmpty(secondName)){
                        convertMap.put("secondName", contacts1.getName());
                    }
                    String secondMobile = contacts1.getPhoneNo();
                    if(StringUtils.isNotEmpty(secondMobile)){
                        convertMap.put("secondMobile", contacts1.getPhoneNo());
                    }
                    String secondRelation = contacts1.getRelationName();
                    if(StringUtils.isNotEmpty(secondRelation)){
                        convertMap.put("secondRelation", contacts1.getRelationName());
                    }
                }
                valuesChecker(contacts1, map, userId);
            }
            if(contacts.size()<2) {
                map.put("checkResult", false);
            }
        }
        if(addresses!=null && addresses.size()>0){
            Address address = addresses.get(0);
            valuesChecker(address, map, userId);
            Long provinceCode = address.getProvinceCode();
            if(provinceCode!=null){
                convertMap.put("provinceCode", address.getProvinceCode());
            }
            String province = address.getProvince();
            if(StringUtils.isNotEmpty(province)){
                convertMap.put("province", address.getProvince());
            }
            Long cityCode = address.getCityCode();
            if(cityCode!=null){
                convertMap.put("cityCode", address.getCityCode());
            }
            String city = address.getCity();
            if(StringUtils.isNotEmpty(city)){
                convertMap.put("city", address.getCity());
            }
            Long districtCode = address.getDistrictCode();
            if(districtCode!=null){
                convertMap.put("districtCode", address.getDistrictCode());
            }
            String district = address.getDistrict();
            if(StringUtils.isNotEmpty(district)){
                convertMap.put("district", address.getDistrict());
            }
            String address1 = address.getAddress();
            if(StringUtils.isNotEmpty(address1)){
                convertMap.put("address", address.getAddress());
            }
        }
    }

    public boolean queryIsSuccess(JSONObject resultJson){
        if("0000".equals(resultJson.getString("code")) && "0000".equals(resultJson.getString("businessCode"))){
            String userInfo = resultJson.getString("data");
            if(StringUtils.isNotEmpty(userInfo)){
                return true;
            }
        }
        return false;
    }

    public static void valuesChecker(Object o, Map<String,Object> map, String userId){
        try{
            Field[] fields = o.getClass().getDeclaredFields();
            Object[] values = new Object[fields.length];
            Object[] names = new Object[fields.length];
            for(int i=0;i<names.length;i++){
                fields[i].setAccessible(true);
                values[i] = fields[i].get(o);
                if(values[i]==null || "".equals(values[i]) || "未知".equals(values[i]) || "暂未填写".equals(values[i])){
                    map.put("checkResult", false);
                    break;
                }
            }
        }catch(Exception e){
            map.put("checkResult", false);
            log.error("校验基本信息参数异常, userId:{}", userId, e);
        }
    }

    private static NiwodaiCostant.Occupation conversOccupation(String occupation){
        switch (occupation){
            case ("工人") :
            case ("公司职员") :
            case ("白领") :
            case ("教师") :
                return NiwodaiCostant.Occupation.WORKER;
            case ("学生") : return NiwodaiCostant.Occupation.STUDENT;
            case ("创业者") : return NiwodaiCostant.Occupation.PROFESSIONAL;
            case ("个体户") :
            case ("网店店主") :
                return NiwodaiCostant.Occupation.PRIVATE_OWNERS;
            case ("企业法人") :  return NiwodaiCostant.Occupation.BUSINESSMEN;
            case ("暂无职业") :
            case ("其他") :
            default:return NiwodaiCostant.Occupation.BE_UNEMPLOYED;
        }
    }
    private static NiwodaiCostant.EducationalBackground conversEducation(String education){
        switch (education){
            case ("小学"):
            case ("初中") : return NiwodaiCostant.EducationalBackground.JUNIOR_SCHOOL_AND_BELOW;
            case ("高中"):
            case ("技校"):
            case ("中专"): return NiwodaiCostant.EducationalBackground.HIGH_SCHOOL;
            case ("大专") : return NiwodaiCostant.EducationalBackground.ACADEMY;
            case ("本科") : return NiwodaiCostant.EducationalBackground.UNIVERSITY;
            case ("硕士及以上") : return NiwodaiCostant.EducationalBackground.POSTGRADUATE_AND_ABOVE;
            default:return NiwodaiCostant.EducationalBackground.JUNIOR_SCHOOL_AND_BELOW;
        }
    }

    private static NiwodaiCostant.Income conversIncome(String income){
        switch (income){
            case ("1000至3000元"): return NiwodaiCostant.Income.ONE;
            case ("3000至5000元"): return NiwodaiCostant.Income.TWO;
            case ("5000至8000元"):
            case ("8000至10000元"): return NiwodaiCostant.Income.THREE;
            case ("10000至15000元"): return NiwodaiCostant.Income.FOUR;
            case ("15000至20000元"): return NiwodaiCostant.Income.FIVE;
            case ("大于20000元"): return NiwodaiCostant.Income.SIX;
            case ("小于1000元"):
            default:return NiwodaiCostant.Income.ZERO;
        }
    }

    private static NiwodaiCostant.MaritalStatus conversMarryStatus(String marryStatus){
        switch (marryStatus){
            case ("已婚") : return NiwodaiCostant.MaritalStatus.MARRIED;
            case ("离异") : return NiwodaiCostant.MaritalStatus.DIVORCE;
            case ("丧偶") : return NiwodaiCostant.MaritalStatus.WIDOWEDSPOUSE;
            case ("未知") :
            case ("未婚") :
            default:return NiwodaiCostant.MaritalStatus.UNMARRIED;
        }
    }

    private static NiwodaiCostant.Relationship conversRelationship(String relationship){
        switch (relationship){
            case ("父母") : return NiwodaiCostant.Relationship.MOTHER;
            case ("子女") : return NiwodaiCostant.Relationship.SON;
            case ("兄弟姐妹") : return NiwodaiCostant.Relationship.BROTHER;
            case ("同事") : return NiwodaiCostant.Relationship.COLLEAGUE;
            case ("同学") : return NiwodaiCostant.Relationship.CLASSMATE;
            case ("朋友") : return NiwodaiCostant.Relationship.FRIEND;
            case ("夫妻") : return NiwodaiCostant.Relationship.SPOUSE;
            case ("本人") :
            case ("其他")  :
            default: return NiwodaiCostant.Relationship.OTHER;
        }
    }


}
