package com.quantgroup.asset.distribution.service.jpa.entity;

import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;

/**
 * 资产表
 * @author liwenbin
 *
 */
@Table(name = "asset")
@Entity
@Data
public class Asset {
	
	@Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;
	
	@Column(name = "asset_no")
	private String assetNo;
	
	@Column(name = "biz_no")
	private String bizNo;
	
	@Column(name = "uuid")
	private String uuid;
	
	@Column(name = "user_loan_type")
	private Integer userLoanType;
	
	@Column(name = "biz_channel")
	private String bizChannel;
	
	@Column(name = "finance_product_type")
	private Integer financeProductType;
	
	@Column(name = "effective_time")
	private Timestamp effectiveTime;
	
	@Column(name = "audit_result")
	private Integer auditResult;
	
	@Column(name = "enable")
	private Boolean enable;
	
	@Column(name = "created_at")
	private Timestamp createdAt;
	
	@Column(name = "updated_at")
	private Timestamp updatedAt;
	
	@PrePersist
    public void prePersist() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        createdAt = timestamp;
        updatedAt = timestamp;
    }

    @PreUpdate
    public void preUpdate() {
        updatedAt = new Timestamp(System.currentTimeMillis());
    }
}
