package com.quantgroup.asset.distribution.service.jpa.entity;

import javax.persistence.*;
import java.sql.Timestamp;
import java.util.Objects;

/**
 * @author shihuajun
 * @date 2021/8/26 17:57
 * @ describing
 */
@Entity
@Table(name = "white_list", schema = "asset-distribution")
public class WhiteListEntity {
    private long id;
    private long fundProductId;
    private String phone;
    private long fundId;
    private long fundCorpId;
    private String fundName;
    private String fundType;
    private String orgType;
    private String businessType;
    private Byte status;
    private Timestamp createdAt;
    private Timestamp updatedAt;

    @Id
    @Column(name = "id", nullable = false)
    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Basic
    @Column(name = "fund_product_id", nullable = false)
    public long getFundProductId() {
        return fundProductId;
    }

    public void setFundProductId(long fundProductId) {
        this.fundProductId = fundProductId;
    }

    @Basic
    @Column(name = "phone", nullable = true, length = 20)
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Basic
    @Column(name = "fund_id", nullable = false)
    public long getFundId() {
        return fundId;
    }

    public void setFundId(long fundId) {
        this.fundId = fundId;
    }

    @Basic
    @Column(name = "fund_corp_id", nullable = false)
    public long getFundCorpId() {
        return fundCorpId;
    }

    public void setFundCorpId(long fundCorpId) {
        this.fundCorpId = fundCorpId;
    }

    @Basic
    @Column(name = "fund_name", nullable = false, length = 100)
    public String getFundName() {
        return fundName;
    }

    public void setFundName(String fundName) {
        this.fundName = fundName;
    }

    @Basic
    @Column(name = "fund_type", nullable = false, length = 20)
    public String getFundType() {
        return fundType;
    }

    public void setFundType(String fundType) {
        this.fundType = fundType;
    }

    @Basic
    @Column(name = "org_type", nullable = false, length = 20)
    public String getOrgType() {
        return orgType;
    }

    public void setOrgType(String orgType) {
        this.orgType = orgType;
    }

    @Basic
    @Column(name = "business_type", nullable = false, length = 20)
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    @Basic
    @Column(name = "status", nullable = true)
    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    @Basic
    @Column(name = "created_at", nullable = false)
    public Timestamp getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(Timestamp createdAt) {
        this.createdAt = createdAt;
    }

    @Basic
    @Column(name = "updated_at", nullable = false)
    public Timestamp getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(Timestamp updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        WhiteListEntity that = (WhiteListEntity) o;
        return id == that.id && fundProductId == that.fundProductId && fundId == that.fundId && fundCorpId == that.fundCorpId && Objects.equals(phone, that.phone) && Objects.equals(fundName, that.fundName) && Objects.equals(fundType, that.fundType) && Objects.equals(orgType, that.orgType) && Objects.equals(businessType, that.businessType) && Objects.equals(status, that.status) && Objects.equals(createdAt, that.createdAt) && Objects.equals(updatedAt, that.updatedAt);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, fundProductId, phone, fundId, fundCorpId, fundName, fundType, orgType, businessType, status, createdAt, updatedAt);
    }
}
