package com.quantgroup.asset.distribution.util.ruleRelation;

import lombok.Data;

import java.util.List;

/**
 * @author jian.zheng
 */
public class Range<T> {

    private RangeType rangeType;
    private List<T> items;
    private Aggregation aggregation;

    /**
     * @author jian.zheng
     */
    public enum RangeType{
        /**
         * 数字
         */
        NUMERIC,
        /**
         * 数组
         */
        ARRAY;
    }

    @Data
    public static class Aggregation {
        private Number start;
        private boolean startClosed;
        private Number end;
        private boolean endClosed;

    }
}
