package com.quantgroup.asset.distribution.service.jpa.entity;

import java.io.Serializable;
import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;

import lombok.Data;

/**
 * 资产分发记录表
 * @author liwenbin
 *
 */
@Table(name = "asset_distribute_record")
@Entity
@Data
public class AssetDistributeRecord implements Serializable{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;
	
	@Column(name = "asset_no")
	private String assetNo;
	
	@Column(name = "uuid")
	private String uuid;
	
	@Column(name = "user_loan_type")
	private Integer userLoanType;
	
	@Column(name = "biz_channel")
	private String bizChannel;
	
	@Column(name = "finance_product_type")
	private Integer financeProductType;
	
	@Column(name = "biz_no")
	private String bizNo;
	
	@Column(name = "asset_distribute_travel")
	private String assetDistributeTravel;
	
	@Column(name = "asset_distribute_target")
	private Integer assetDistributeTarget;
	
	@Column(name = "asset_distribute_status")
	private Integer assetDistributeStatus;
	
	@Column(name = "enable")
	private Boolean enable;
	
	@Column(name = "created_at")
	private Timestamp createdAt;
	
	@Column(name = "updated_at")
	private Timestamp updatedAt;
	
	@PrePersist
    public void prePersist() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        createdAt = timestamp;
        updatedAt = timestamp;
    }

    @PreUpdate
    public void preUpdate() {
        updatedAt = new Timestamp(System.currentTimeMillis());
    }
}
